/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spark;

import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.spark.RddCallback;
import org.apache.camel.component.spark.SparkEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaRDDLike;

public class RddSparkProducer
extends DefaultProducer {
    public RddSparkProducer(SparkEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        JavaRDDLike rdd = this.resolveRdd(exchange);
        RddCallback rddCallback = this.resolveRddCallback(exchange);
        Object body = exchange.getIn().getBody();
        Object result = body instanceof List ? rddCallback.onRdd(rdd, ((List)body).toArray(new Object[0])) : rddCallback.onRdd(rdd, body);
        this.collectResults(exchange, result);
    }

    public SparkEndpoint getEndpoint() {
        return (SparkEndpoint)super.getEndpoint();
    }

    protected void collectResults(Exchange exchange, Object result) {
        if (result instanceof JavaRDD) {
            JavaRDD rddResults = (JavaRDD)result;
            if (this.getEndpoint().isCollect()) {
                exchange.getIn().setBody((Object)rddResults.collect());
            } else {
                exchange.getIn().setBody(result);
                exchange.getIn().setHeader("CAMEL_SPARK_RDD", result);
            }
        } else {
            exchange.getIn().setBody(result);
        }
    }

    protected JavaRDDLike resolveRdd(Exchange exchange) {
        if (exchange.getIn().getHeader("CAMEL_SPARK_RDD") != null) {
            return (JavaRDD)exchange.getIn().getHeader("CAMEL_SPARK_RDD");
        }
        if (this.getEndpoint().getRdd() != null) {
            return this.getEndpoint().getRdd();
        }
        throw new IllegalStateException("No RDD defined.");
    }

    protected RddCallback resolveRddCallback(Exchange exchange) {
        if (exchange.getIn().getHeader("CAMEL_SPARK_RDD_CALLBACK") != null) {
            return (RddCallback)exchange.getIn().getHeader("CAMEL_SPARK_RDD_CALLBACK");
        }
        if (this.getEndpoint().getRddCallback() != null) {
            return this.getEndpoint().getRddCallback();
        }
        throw new IllegalStateException("Cannot resolve RDD callback.");
    }
}

