/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elasticsearch;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.elasticsearch.ElasticsearchComponent;
import org.apache.camel.component.elasticsearch.ElasticsearchConfiguration;
import org.apache.camel.component.elasticsearch.ElasticsearchProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.elasticsearch.client.RestClient;

@UriEndpoint(firstVersion="2.21.0", scheme="elasticsearch-rest", title="Elastichsearch Rest", syntax="elasticsearch-rest:clusterName", producerOnly=true, label="monitoring,search")
public class ElasticsearchEndpoint
extends DefaultEndpoint {
    @UriParam
    private final ElasticsearchConfiguration configuration;
    private RestClient client;

    public ElasticsearchEndpoint(String uri, ElasticsearchComponent component, ElasticsearchConfiguration config, RestClient client) throws Exception {
        super(uri, (Component)component);
        this.configuration = config;
        this.client = client;
    }

    public Producer createProducer() throws Exception {
        return new ElasticsearchProducer(this, this.configuration);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Cannot consume from an ElasticsearchEndpoint: " + this.getEndpointUri());
    }

    public boolean isSingleton() {
        return true;
    }

    public RestClient getClient() {
        return this.client;
    }
}

