/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.reactive.streams.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.apache.camel.Exchange;

public final class BodyConverter<T>
implements Function<Exchange, T> {
    private static final ConcurrentMap<Class<?>, BodyConverter<?>> CACHE = new ConcurrentHashMap();
    private final Class<T> type;

    BodyConverter(Class<T> type) {
        this.type = type;
    }

    @Override
    public T apply(Exchange exchange) {
        Object answer = exchange.hasOut() ? exchange.getOut().getBody(this.type) : exchange.getIn().getBody(this.type);
        return (T)answer;
    }

    public static <C> BodyConverter<C> forType(Class<C> type) {
        return (BodyConverter)BodyConverter.class.cast(CACHE.computeIfAbsent(type, BodyConverter::new));
    }
}

