/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.reactive.streams.engine;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.reactive.streams.ReactiveStreamsCamelSubscriber;
import org.apache.camel.component.reactive.streams.ReactiveStreamsConsumer;
import org.apache.camel.component.reactive.streams.ReactiveStreamsHelper;
import org.apache.camel.component.reactive.streams.ReactiveStreamsProducer;
import org.apache.camel.component.reactive.streams.api.CamelReactiveStreamsService;
import org.apache.camel.component.reactive.streams.engine.CamelPublisher;
import org.apache.camel.component.reactive.streams.engine.CamelSubscription;
import org.apache.camel.component.reactive.streams.engine.DelayedMonoPublisher;
import org.apache.camel.component.reactive.streams.engine.ReactiveStreamsEngineConfiguration;
import org.apache.camel.component.reactive.streams.engine.UnwrappingPublisher;
import org.apache.camel.component.reactive.streams.util.ConvertingPublisher;
import org.apache.camel.component.reactive.streams.util.ConvertingSubscriber;
import org.apache.camel.component.reactive.streams.util.MonoPublisher;
import org.apache.camel.component.reactive.streams.util.UnwrapStreamProcessor;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.function.Suppliers;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

@ManagedResource(description="Managed CamelReactiveStreamsService")
public class DefaultCamelReactiveStreamsService
extends ServiceSupport
implements CamelReactiveStreamsService {
    private final CamelContext context;
    private final ReactiveStreamsEngineConfiguration configuration;
    private final Supplier<UnwrapStreamProcessor> unwrapStreamProcessorSupplier;
    private ExecutorService workerPool;
    private final ConcurrentMap<String, CamelPublisher> publishers = new ConcurrentHashMap<String, CamelPublisher>();
    private final ConcurrentMap<String, ReactiveStreamsCamelSubscriber> subscribers = new ConcurrentHashMap<String, ReactiveStreamsCamelSubscriber>();
    private final ConcurrentMap<String, String> publishedUriToStream = new ConcurrentHashMap<String, String>();
    private final ConcurrentMap<String, String> requestedUriToStream = new ConcurrentHashMap<String, String>();

    public DefaultCamelReactiveStreamsService(CamelContext context, ReactiveStreamsEngineConfiguration configuration) {
        this.context = context;
        this.configuration = configuration;
        this.unwrapStreamProcessorSupplier = Suppliers.memorize(UnwrapStreamProcessor::new);
        this.init();
    }

    public String getId() {
        return "default-service";
    }

    private void init() {
        if (this.workerPool == null) {
            this.workerPool = this.context.getExecutorServiceManager().newThreadPool((Object)this, this.configuration.getThreadPoolName(), this.configuration.getThreadPoolMinSize(), this.configuration.getThreadPoolMaxSize());
        }
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
        if (this.workerPool != null) {
            this.context.getExecutorServiceManager().shutdownNow(this.workerPool);
            this.workerPool = null;
        }
    }

    @Override
    public Publisher<Exchange> fromStream(String name) {
        return new UnwrappingPublisher(this.getPayloadPublisher(name));
    }

    @Override
    public <T> Publisher<T> fromStream(String name, Class<T> cls) {
        if (Exchange.class.equals(cls)) {
            return this.fromStream(name);
        }
        return new ConvertingPublisher<T>(this.fromStream(name), cls);
    }

    public ReactiveStreamsCamelSubscriber streamSubscriber(String name) {
        return this.subscribers.computeIfAbsent(name, n -> new ReactiveStreamsCamelSubscriber(name));
    }

    @Override
    public <T> Subscriber<T> streamSubscriber(String name, Class<T> type) {
        if (Exchange.class.equals(type)) {
            return this.streamSubscriber(name);
        }
        return new ConvertingSubscriber(this.streamSubscriber(name), this.context);
    }

    @Override
    public void sendCamelExchange(String name, Exchange exchange) {
        this.getPayloadPublisher(name).publish(exchange);
    }

    @Override
    public Publisher<Exchange> toStream(String name, Object data) {
        Exchange exchange = ReactiveStreamsHelper.convertToExchange(this.context, data);
        return this.doRequest(name, exchange);
    }

    @Override
    public Function<?, ? extends Publisher<Exchange>> toStream(String name) {
        return data -> this.toStream(name, data);
    }

    @Override
    public <T> Publisher<T> toStream(String name, Object data, Class<T> type) {
        return new ConvertingPublisher<T>(this.toStream(name, data), type);
    }

    protected Publisher<Exchange> doRequest(String name, Exchange data) {
        ReactiveStreamsConsumer consumer = this.streamSubscriber(name).getConsumer();
        if (consumer == null) {
            throw new IllegalStateException("No consumers attached to the stream " + name);
        }
        final DelayedMonoPublisher<Exchange> publisher = new DelayedMonoPublisher<Exchange>(this.workerPool);
        data.addOnCompletion(new Synchronization(){

            public void onComplete(Exchange exchange) {
                publisher.setData(exchange);
            }

            public void onFailure(Exchange exchange) {
                Exception throwable = exchange.getException();
                if (throwable == null) {
                    throwable = new IllegalStateException("Unknown Exception");
                }
                publisher.setException(throwable);
            }
        });
        consumer.process(data, doneSync -> {});
        return publisher;
    }

    @Override
    public <T> Function<Object, Publisher<T>> toStream(String name, Class<T> type) {
        return data -> this.toStream(name, data, type);
    }

    private CamelPublisher getPayloadPublisher(String name) {
        this.publishers.computeIfAbsent(name, n -> new CamelPublisher(this.workerPool, this.context, (String)n));
        return (CamelPublisher)this.publishers.get(name);
    }

    @Override
    public Publisher<Exchange> from(String uri) {
        this.publishedUriToStream.computeIfAbsent(uri, u -> {
            try {
                String uuid = this.context.getUuidGenerator().generateUuid();
                new RouteBuilder((String)u, uuid){
                    final /* synthetic */ String val$u;
                    final /* synthetic */ String val$uuid;
                    {
                        this.val$u = string;
                        this.val$uuid = string2;
                    }

                    public void configure() throws Exception {
                        this.from(this.val$u).to("reactive-streams:" + this.val$uuid);
                    }
                }.addRoutesToCamelContext(this.context);
                return uuid;
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to create source reactive stream from direct URI: " + uri, e);
            }
        });
        return this.fromStream((String)this.publishedUriToStream.get(uri));
    }

    @Override
    public <T> Publisher<T> from(String uri, Class<T> type) {
        return new ConvertingPublisher<T>(this.from(uri), type);
    }

    @Override
    public Subscriber<Exchange> subscriber(final String uri) {
        try {
            final String uuid = this.context.getUuidGenerator().generateUuid();
            new RouteBuilder(){

                public void configure() throws Exception {
                    this.from("reactive-streams:" + uuid).to(uri);
                }
            }.addRoutesToCamelContext(this.context);
            return this.streamSubscriber(uuid);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to create source reactive stream towards direct URI: " + uri, e);
        }
    }

    @Override
    public <T> Subscriber<T> subscriber(String uri, Class<T> type) {
        return new ConvertingSubscriber(this.subscriber(uri), this.context);
    }

    @Override
    public Publisher<Exchange> to(String uri, Object data) {
        this.requestedUriToStream.computeIfAbsent(uri, u -> {
            try {
                final String uuid = this.context.getUuidGenerator().generateUuid();
                new RouteBuilder((String)u){
                    final /* synthetic */ String val$u;
                    {
                        this.val$u = string2;
                    }

                    public void configure() throws Exception {
                        this.from("reactive-streams:" + uuid).to(this.val$u);
                    }
                }.addRoutesToCamelContext(this.context);
                return uuid;
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to create requested reactive stream from direct URI: " + uri, e);
            }
        });
        return this.toStream((String)this.requestedUriToStream.get(uri), data);
    }

    @Override
    public Function<Object, Publisher<Exchange>> to(String uri) {
        return data -> this.to(uri, data);
    }

    @Override
    public <T> Publisher<T> to(String uri, Object data, Class<T> type) {
        return new ConvertingPublisher<T>(this.to(uri, data), type);
    }

    @Override
    public <T> Function<Object, Publisher<T>> to(String uri, Class<T> type) {
        return data -> this.to(uri, data, type);
    }

    @Override
    public void process(final String uri, final Function<? super Publisher<Exchange>, ?> processor) {
        try {
            new RouteBuilder(){

                public void configure() throws Exception {
                    ((RouteDefinition)this.from(uri).process(exchange -> {
                        Exchange copy = exchange.copy();
                        Object result = processor.apply(new MonoPublisher<Exchange>(copy));
                        exchange.getIn().setBody(result);
                    })).process((Processor)DefaultCamelReactiveStreamsService.this.unwrapStreamProcessorSupplier.get());
                }
            }.addRoutesToCamelContext(this.context);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to add reactive stream processor to the direct URI: " + uri, e);
        }
    }

    @Override
    public <T> void process(String uri, Class<T> type, Function<? super Publisher<T>, ?> processor) {
        this.process(uri, exPub -> processor.apply(new ConvertingPublisher((Publisher<Exchange>)exPub, type)));
    }

    @Override
    public ReactiveStreamsCamelSubscriber attachCamelConsumer(String name, ReactiveStreamsConsumer consumer) {
        ReactiveStreamsCamelSubscriber subscriber = this.streamSubscriber(name);
        subscriber.attachConsumer(consumer);
        return subscriber;
    }

    @Override
    public void detachCamelConsumer(String name) {
        this.streamSubscriber(name).detachConsumer();
    }

    @Override
    public void attachCamelProducer(String name, ReactiveStreamsProducer producer) {
        this.getPayloadPublisher(name).attachProducer(producer);
    }

    @Override
    public void detachCamelProducer(String name) {
        this.getPayloadPublisher(name).detachProducer();
    }

    @ManagedOperation(description="Information about Camel Reactive subscribers")
    public TabularData camelSubscribers() {
        try {
            TabularDataSupport answer = new TabularDataSupport(DefaultCamelReactiveStreamsService.subscribersTabularType());
            this.subscribers.forEach((k, v) -> {
                try {
                    String name = k;
                    long inflight = v.getInflightCount();
                    long requested = v.getRequested();
                    CompositeType ct = DefaultCamelReactiveStreamsService.subscribersCompositeType();
                    CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"name", "inflight", "requested"}, new Object[]{name, inflight, requested});
                    answer.put(data);
                }
                catch (Exception e) {
                    throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
                }
            });
            return answer;
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
    }

    @ManagedOperation(description="Information about Camel Reactive publishers")
    public TabularData camelPublishers() {
        try {
            TabularDataSupport answer = new TabularDataSupport(DefaultCamelReactiveStreamsService.publishersTabularType());
            this.publishers.forEach((k, v) -> {
                try {
                    String name = k;
                    List<CamelSubscription> subscriptions = v.getSubscriptions();
                    int subscribers = subscriptions.size();
                    TabularDataSupport subscriptionData = new TabularDataSupport(DefaultCamelReactiveStreamsService.subscriptionsTabularType());
                    CompositeType subCt = DefaultCamelReactiveStreamsService.subscriptionsCompositeType();
                    for (CamelSubscription sub : subscriptions) {
                        String id = sub.getId();
                        long bufferSize = sub.getBufferSize();
                        String backpressure = sub.getBackpressureStrategy() != null ? sub.getBackpressureStrategy().name() : "";
                        CompositeDataSupport subData = new CompositeDataSupport(subCt, new String[]{"name", "buffer size", "back pressure"}, new Object[]{id, bufferSize, backpressure});
                        subscriptionData.put(subData);
                    }
                    CompositeType ct = DefaultCamelReactiveStreamsService.publishersCompositeType();
                    CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"name", "subscribers", "subscriptions"}, new Object[]{name, subscribers, subscriptionData});
                    answer.put(data);
                }
                catch (Exception e) {
                    throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
                }
            });
            return answer;
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
    }

    private static TabularType subscribersTabularType() throws OpenDataException {
        CompositeType ct = DefaultCamelReactiveStreamsService.subscribersCompositeType();
        return new TabularType("subscribers", "Information about Camel Reactive subscribers", ct, new String[]{"name"});
    }

    private static CompositeType subscribersCompositeType() throws OpenDataException {
        return new CompositeType("subscriptions", "Subscriptions", new String[]{"name", "inflight", "requested"}, new String[]{"Name", "Inflight", "Requested"}, new OpenType[]{SimpleType.STRING, SimpleType.LONG, SimpleType.LONG});
    }

    private static CompositeType publishersCompositeType() throws OpenDataException {
        return new CompositeType("publishers", "Publishers", new String[]{"name", "subscribers", "subscriptions"}, new String[]{"Name", "Subscribers", "Subscriptions"}, new OpenType[]{SimpleType.STRING, SimpleType.INTEGER, DefaultCamelReactiveStreamsService.subscriptionsTabularType()});
    }

    private static TabularType subscriptionsTabularType() throws OpenDataException {
        CompositeType ct = DefaultCamelReactiveStreamsService.subscriptionsCompositeType();
        return new TabularType("subscriptions", "Information about External Reactive subscribers", ct, new String[]{"name"});
    }

    private static CompositeType subscriptionsCompositeType() throws OpenDataException {
        return new CompositeType("subscriptions", "Subscriptions", new String[]{"name", "buffer size", "back pressure"}, new String[]{"Name", "Buffer Size", "Back Pressure"}, new OpenType[]{SimpleType.STRING, SimpleType.LONG, SimpleType.STRING});
    }

    private static TabularType publishersTabularType() throws OpenDataException {
        CompositeType ct = DefaultCamelReactiveStreamsService.publishersCompositeType();
        return new TabularType("publishers", "Information about Camel Reactive publishers", ct, new String[]{"name"});
    }
}

