/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.asterisk;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.asterisk.AsteriskConnection;
import org.apache.camel.component.asterisk.AsteriskEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.asteriskjava.manager.ManagerEventListener;
import org.asteriskjava.manager.event.ManagerEvent;

public class AsteriskConsumer
extends DefaultConsumer {
    private final AsteriskEndpoint endpoint;
    private final AsteriskConnection connection;
    private final ManagerEventListener listener;

    public AsteriskConsumer(AsteriskEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.connection = new AsteriskConnection(endpoint.getHostname(), endpoint.getUsername(), endpoint.getPassword());
        this.listener = new EventListener();
    }

    protected void doStart() throws Exception {
        this.connection.connect();
        this.connection.addListener(this.listener);
        this.connection.login();
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.connection.removeListener(this.listener);
        this.connection.logoff();
    }

    private final class EventListener
    implements ManagerEventListener {
        private EventListener() {
        }

        public void onManagerEvent(ManagerEvent event) {
            Exchange exchange = AsteriskConsumer.this.endpoint.createExchange();
            exchange.getIn().setHeader("CamelAsteriskEventName", (Object)event.getClass().getSimpleName());
            exchange.getIn().setBody((Object)event);
            try {
                AsteriskConsumer.this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                AsteriskConsumer.this.getExceptionHandler().handleException("Error processing exchange.", exchange, (Throwable)e);
            }
        }
    }
}

