/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.telegram.TelegramConfiguration;
import org.apache.camel.component.telegram.TelegramConsumer;
import org.apache.camel.component.telegram.TelegramProducer;
import org.apache.camel.component.telegram.TelegramServiceProvider;
import org.apache.camel.component.telegram.model.Update;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.18.0", scheme="telegram", title="Telegram", syntax="telegram:type/authorizationToken", consumerClass=TelegramConsumer.class, label="chat")
public class TelegramEndpoint
extends ScheduledPollEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(TelegramEndpoint.class);
    @UriParam
    private TelegramConfiguration configuration;

    public TelegramEndpoint(String endpointUri, Component component, TelegramConfiguration configuration) {
        super(endpointUri, component);
        this.configuration = configuration;
        if (ObjectHelper.isNotEmpty((Object)configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)configuration.getProxyPort())) {
            LOG.debug("Setup http proxy host:{} port:{} for TelegramService", (Object)configuration.getProxyHost(), (Object)configuration.getProxyPort());
            TelegramServiceProvider.get().getService().setHttpProxy(configuration.getProxyHost(), configuration.getProxyPort());
        }
    }

    public Producer createProducer() throws Exception {
        return new TelegramProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        TelegramConsumer consumer = new TelegramConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public Exchange createExchange(Update update) {
        Exchange exchange = super.createExchange();
        if (update.getMessage() != null) {
            exchange.getIn().setBody((Object)update.getMessage());
            if (update.getMessage().getChat() != null) {
                exchange.getIn().setHeader("CamelTelegramChatId", (Object)update.getMessage().getChat().getId());
            }
        } else if (update.getChannelPost() != null) {
            exchange.getIn().setBody((Object)update.getChannelPost());
            if (update.getChannelPost().getChat() != null) {
                exchange.getIn().setHeader("CamelTelegramChatId", (Object)update.getChannelPost().getChat().getId());
            }
        }
        return exchange;
    }

    public boolean isSingleton() {
        return true;
    }

    public TelegramConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(TelegramConfiguration configuration) {
        this.configuration = configuration;
    }
}

