/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.jms.ConnectionFactory;
import org.apache.camel.CamelException;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.sjms.SjmsEndpoint;
import org.apache.camel.component.sjms.TransactionCommitStrategy;
import org.apache.camel.component.sjms.jms.ConnectionResource;
import org.apache.camel.component.sjms.jms.DefaultJmsKeyFormatStrategy;
import org.apache.camel.component.sjms.jms.DestinationCreationStrategy;
import org.apache.camel.component.sjms.jms.JmsKeyFormatStrategy;
import org.apache.camel.component.sjms.jms.MessageCreatedStrategy;
import org.apache.camel.component.sjms.taskmanager.TimedTaskManager;
import org.apache.camel.impl.HeaderFilterStrategyComponent;
import org.apache.camel.spi.Metadata;

public class SjmsComponent
extends HeaderFilterStrategyComponent {
    private ExecutorService asyncStartStopExecutorService;
    @Metadata(label="advanced", description="A ConnectionFactory is required to enable the SjmsComponent. It can be set directly or set set as part of a ConnectionResource.")
    private ConnectionFactory connectionFactory;
    @Metadata(label="advanced", description="A ConnectionResource is an interface that allows for customization and container control of the ConnectionFactory. * See Plugable Connection Resource Management for further details.")
    private ConnectionResource connectionResource;
    @Metadata(label="advanced", description="Pluggable strategy for encoding and decoding JMS keys so they can be compliant with the JMS specification. Camel provides one implementation out of the box: default. The default strategy will safely marshal dots and hyphens (. and -). Can be used for JMS brokers which do not care whether JMS header keys contain illegal characters. You can provide your own implementation of the org.apache.camel.component.jms.JmsKeyFormatStrategy and refer to it using the # notation.")
    private JmsKeyFormatStrategy jmsKeyFormatStrategy = new DefaultJmsKeyFormatStrategy();
    @Metadata(defaultValue="1", description="The maximum number of connections available to endpoints started under this component")
    private Integer connectionCount = 1;
    @Metadata(label="transaction", description="To configure which kind of commit strategy to use. Camel provides two implementations out of the box, default and batch.")
    private TransactionCommitStrategy transactionCommitStrategy;
    @Metadata(label="advanced", description="To use a custom TimedTaskManager")
    private TimedTaskManager timedTaskManager;
    @Metadata(label="advanced", description="To use a custom DestinationCreationStrategy.")
    private DestinationCreationStrategy destinationCreationStrategy;
    @Metadata(label="advanced", description="To use the given MessageCreatedStrategy which are invoked when Camel creates new instances of <tt>javax.jms.Message</tt> objects when Camel is sending a JMS message.")
    private MessageCreatedStrategy messageCreatedStrategy;
    @Metadata(label="advanced", defaultValue="true", description="When using the default {@link org.apache.camel.component.sjms.jms.ConnectionFactoryResource} then should each {@link javax.jms.Connection} be tested (calling start) before returned from the pool.")
    private boolean connectionTestOnBorrow = true;
    @Metadata(label="security", secret=true, description="The username to use when creating {@link javax.jms.Connection} when using the default {@link org.apache.camel.component.sjms.jms.ConnectionFactoryResource}.")
    private String connectionUsername;
    @Metadata(label="security", secret=true, description="The password to use when creating {@link javax.jms.Connection} when using the default {@link org.apache.camel.component.sjms.jms.ConnectionFactoryResource}.")
    private String connectionPassword;
    @Metadata(label="advanced", description="The client ID to use when creating {@link javax.jms.Connection} when using the default {@link org.apache.camel.component.sjms.jms.ConnectionFactoryResource}.")
    private String connectionClientId;
    @Metadata(label="advanced", defaultValue="5000", description="The max wait time in millis to block and wait on free connection when the pool is exhausted when using the default {@link org.apache.camel.component.sjms.jms.ConnectionFactoryResource}.")
    private long connectionMaxWait = 5000L;

    public SjmsComponent() {
        super(SjmsEndpoint.class);
    }

    protected SjmsComponent(Class<? extends Endpoint> endpointClass) {
        super(endpointClass);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        SjmsComponent.validateMepAndReplyTo(parameters);
        SjmsEndpoint endpoint = this.createSjmsEndpoint(uri, remaining);
        this.setProperties((Object)endpoint, parameters);
        if (endpoint.isTransacted()) {
            endpoint.setSynchronous(true);
        }
        if (this.transactionCommitStrategy != null) {
            endpoint.setTransactionCommitStrategy(this.transactionCommitStrategy);
        }
        if (this.destinationCreationStrategy != null) {
            endpoint.setDestinationCreationStrategy(this.destinationCreationStrategy);
        }
        if (this.getHeaderFilterStrategy() != null) {
            endpoint.setHeaderFilterStrategy(this.getHeaderFilterStrategy());
        }
        if (this.messageCreatedStrategy != null) {
            endpoint.setMessageCreatedStrategy(this.messageCreatedStrategy);
        }
        return endpoint;
    }

    protected SjmsEndpoint createSjmsEndpoint(String uri, String remaining) {
        return new SjmsEndpoint(uri, (Component)this, remaining);
    }

    private static void validateMepAndReplyTo(Map<String, Object> parameters) throws Exception {
        boolean namedReplyToSet = parameters.containsKey("namedReplyTo");
        boolean mepSet = parameters.containsKey("exchangePattern");
        if (namedReplyToSet && mepSet && !parameters.get("exchangePattern").equals(ExchangePattern.InOut.toString())) {
            String namedReplyTo = (String)parameters.get("namedReplyTo");
            ExchangePattern mep = ExchangePattern.valueOf((String)((String)parameters.get("exchangePattern")));
            throw new CamelException("Setting parameter namedReplyTo=" + namedReplyTo + " requires a MEP of type InOut. Parameter exchangePattern is set to " + mep);
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.timedTaskManager = new TimedTaskManager();
    }

    protected void doStop() throws Exception {
        if (this.timedTaskManager != null) {
            this.timedTaskManager.cancelTasks();
            this.timedTaskManager = null;
        }
        super.doStop();
    }

    protected void doShutdown() throws Exception {
        if (this.asyncStartStopExecutorService != null) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow(this.asyncStartStopExecutorService);
            this.asyncStartStopExecutorService = null;
        }
        super.doShutdown();
    }

    protected synchronized ExecutorService getAsyncStartStopExecutorService() {
        if (this.asyncStartStopExecutorService == null) {
            this.asyncStartStopExecutorService = this.getCamelContext().getExecutorServiceManager().newCachedThreadPool((Object)this, "AsyncStartStopListener");
        }
        return this.asyncStartStopExecutorService;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionResource(ConnectionResource connectionResource) {
        this.connectionResource = connectionResource;
    }

    public ConnectionResource getConnectionResource() {
        return this.connectionResource;
    }

    public void setConnectionCount(Integer maxConnections) {
        this.connectionCount = maxConnections;
    }

    public Integer getConnectionCount() {
        return this.connectionCount;
    }

    public void setJmsKeyFormatStrategy(JmsKeyFormatStrategy jmsKeyFormatStrategy) {
        this.jmsKeyFormatStrategy = jmsKeyFormatStrategy;
    }

    public JmsKeyFormatStrategy getJmsKeyFormatStrategy() {
        return this.jmsKeyFormatStrategy;
    }

    public TransactionCommitStrategy getTransactionCommitStrategy() {
        return this.transactionCommitStrategy;
    }

    public void setTransactionCommitStrategy(TransactionCommitStrategy commitStrategy) {
        this.transactionCommitStrategy = commitStrategy;
    }

    public DestinationCreationStrategy getDestinationCreationStrategy() {
        return this.destinationCreationStrategy;
    }

    public void setDestinationCreationStrategy(DestinationCreationStrategy destinationCreationStrategy) {
        this.destinationCreationStrategy = destinationCreationStrategy;
    }

    public TimedTaskManager getTimedTaskManager() {
        return this.timedTaskManager;
    }

    public void setTimedTaskManager(TimedTaskManager timedTaskManager) {
        this.timedTaskManager = timedTaskManager;
    }

    public MessageCreatedStrategy getMessageCreatedStrategy() {
        return this.messageCreatedStrategy;
    }

    public void setMessageCreatedStrategy(MessageCreatedStrategy messageCreatedStrategy) {
        this.messageCreatedStrategy = messageCreatedStrategy;
    }

    public boolean isConnectionTestOnBorrow() {
        return this.connectionTestOnBorrow;
    }

    public void setConnectionTestOnBorrow(boolean connectionTestOnBorrow) {
        this.connectionTestOnBorrow = connectionTestOnBorrow;
    }

    public String getConnectionUsername() {
        return this.connectionUsername;
    }

    public void setConnectionUsername(String connectionUsername) {
        this.connectionUsername = connectionUsername;
    }

    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    public void setConnectionPassword(String connectionPassword) {
        this.connectionPassword = connectionPassword;
    }

    public String getConnectionClientId() {
        return this.connectionClientId;
    }

    public void setConnectionClientId(String connectionClientId) {
        this.connectionClientId = connectionClientId;
    }

    public long getConnectionMaxWait() {
        return this.connectionMaxWait;
    }

    public void setConnectionMaxWait(long connectionMaxWait) {
        this.connectionMaxWait = connectionMaxWait;
    }
}

