/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.chronicle.engine;

import net.openhft.chronicle.engine.api.map.MapEvent;
import net.openhft.chronicle.engine.map.InsertedEvent;
import net.openhft.chronicle.engine.map.RemovedEvent;
import net.openhft.chronicle.engine.map.UpdatedEvent;

public enum ChronicleEngineMapEventType {
    INSERT(InsertedEvent.class),
    UPDATE(UpdatedEvent.class),
    REMOVE(RemovedEvent.class);

    private static final ChronicleEngineMapEventType[] VALUES;
    private final Class<? extends MapEvent> type;

    private ChronicleEngineMapEventType(Class<? extends MapEvent> type) {
        this.type = type;
    }

    public Class<? extends MapEvent> getType() {
        return this.type;
    }

    public static Class<? extends MapEvent> getType(String name) {
        return ChronicleEngineMapEventType.valueOf(name.toUpperCase()).getType();
    }

    public static ChronicleEngineMapEventType fromEvent(MapEvent event) {
        if (event instanceof InsertedEvent) {
            return INSERT;
        }
        if (event instanceof UpdatedEvent) {
            return UPDATE;
        }
        if (event instanceof RemovedEvent) {
            return REMOVE;
        }
        throw new IllegalArgumentException("Unknown event type: " + event.getClass());
    }

    static {
        VALUES = ChronicleEngineMapEventType.values();
    }
}

