/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.grpc.client;

import io.grpc.stub.StreamObserver;
import java.util.LinkedList;
import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;

public class GrpcResponseAggregationStreamObserver
implements StreamObserver<Object> {
    private final Exchange exchange;
    private final AsyncCallback callback;
    private List<Object> responseCollection = new LinkedList<Object>();

    public GrpcResponseAggregationStreamObserver(Exchange exchange, AsyncCallback callback) {
        this.exchange = exchange;
        this.callback = callback;
    }

    public void onNext(Object response) {
        this.responseCollection.add(response);
    }

    public void onError(Throwable throwable) {
        this.exchange.setException(throwable);
        this.callback.done(false);
    }

    public void onCompleted() {
        this.exchange.getOut().setHeaders(this.exchange.getIn().getHeaders());
        this.exchange.getOut().setBody(this.responseCollection);
        this.callback.done(false);
    }
}

