/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jgroups.raft;

import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.jgroups.raft.CamelRoleChangeListener;
import org.apache.camel.component.jgroups.raft.JGroupsRaftEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.jgroups.protocols.raft.RAFT;
import org.jgroups.raft.RaftHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGroupsRaftConsumer
extends DefaultConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(JGroupsRaftConsumer.class);
    private final RaftHandle raftHandle;
    private final String clusterName;
    private boolean enableRoleChangeEvents;
    private final CamelRoleChangeListener roleListener;
    private final JGroupsRaftEndpoint endpoint;

    public JGroupsRaftConsumer(JGroupsRaftEndpoint endpoint, Processor processor, RaftHandle raftHandle, String clusterName, boolean enableRoleChangeEvents) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.raftHandle = raftHandle;
        this.clusterName = clusterName;
        this.enableRoleChangeEvents = enableRoleChangeEvents;
        this.roleListener = new CamelRoleChangeListener(endpoint, processor);
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.enableRoleChangeEvents) {
            LOG.debug("Connecting roleListener : {} to the cluster: {}.", (Object)this.roleListener, (Object)this.clusterName);
            this.raftHandle.addRoleListener((RAFT.RoleChange)this.roleListener);
        }
        this.endpoint.connect();
    }

    protected void doStop() throws Exception {
        if (this.enableRoleChangeEvents) {
            LOG.debug("Closing connection to cluster: {} from roleListener: {}.", (Object)this.clusterName, (Object)this.roleListener);
            this.raftHandle.removeRoleListener((RAFT.RoleChange)this.roleListener);
        }
        this.endpoint.disconnect();
        super.doStop();
    }
}

