/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nagios;

import com.googlecode.jsendnsca.Level;
import com.googlecode.jsendnsca.MessagePayload;
import com.googlecode.jsendnsca.NonBlockingNagiosPassiveCheckSender;
import com.googlecode.jsendnsca.PassiveCheckSender;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.nagios.NagiosEndpoint;
import org.apache.camel.impl.DefaultProducer;

public class NagiosProducer
extends DefaultProducer {
    private final PassiveCheckSender sender;

    public NagiosProducer(NagiosEndpoint endpoint, PassiveCheckSender sender) {
        super((Endpoint)endpoint);
        this.sender = sender;
    }

    public void process(Exchange exchange) throws Exception {
        String message = (String)exchange.getIn().getBody(String.class);
        Level level = (Level)exchange.getIn().getHeader("CamelNagiosLevel", Level.class);
        if (level == null) {
            String name = (String)exchange.getIn().getHeader("CamelNagiosLevel", (Object)Level.OK.name(), String.class);
            level = Level.valueOf((String)name);
        }
        String serviceName = (String)exchange.getIn().getHeader("CamelNagiosServiceName", (Object)exchange.getContext().getName(), String.class);
        String hostName = (String)exchange.getIn().getHeader("CamelNagiosHostName", (Object)"localhost", String.class);
        MessagePayload payload = new MessagePayload(hostName, level, serviceName, message);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sending notification to Nagios: {}", (Object)payload.getMessage());
        }
        this.sender.send(payload);
        this.log.trace("Sending notification done");
    }

    protected void doStart() throws Exception {
        if (this.sender instanceof NonBlockingNagiosPassiveCheckSender) {
            NonBlockingNagiosPassiveCheckSender nonBlocking = (NonBlockingNagiosPassiveCheckSender)this.sender;
            ExecutorService executor = this.getEndpoint().getCamelContext().getExecutorServiceManager().newSingleThreadExecutor((Object)this, this.getEndpoint().getEndpointUri());
            nonBlocking.setExecutor(executor);
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.sender instanceof NonBlockingNagiosPassiveCheckSender) {
            ((NonBlockingNagiosPassiveCheckSender)this.sender).shutdown();
        }
    }
}

