/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.crypto.springboot;

import java.util.HashMap;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.converter.crypto.PGPDataFormat;
import org.apache.camel.converter.crypto.springboot.PGPDataFormatConfiguration;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatCustomizer;
import org.apache.camel.spi.DataFormatFactory;
import org.apache.camel.spi.HasId;
import org.apache.camel.spring.boot.DataFormatConfigurationProperties;
import org.apache.camel.spring.boot.util.CamelPropertiesHelper;
import org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans;
import org.apache.camel.spring.boot.util.GroupCondition;
import org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@Conditional(value={ConditionalOnCamelContextAndAutoConfigurationBeans.class, GroupConditions.class})
@AutoConfigureAfter(name={"org.apache.camel.spring.boot.CamelAutoConfiguration"})
@EnableConfigurationProperties(value={DataFormatConfigurationProperties.class, PGPDataFormatConfiguration.class})
public class PGPDataFormatAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(PGPDataFormatAutoConfiguration.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private CamelContext camelContext;
    @Autowired
    private PGPDataFormatConfiguration configuration;
    @Autowired(required=false)
    private List<DataFormatCustomizer<PGPDataFormat>> customizers;

    @Bean(name={"pgp-dataformat-factory"})
    @ConditionalOnMissingBean(value={PGPDataFormat.class})
    public DataFormatFactory configurePGPDataFormatFactory() throws Exception {
        return new DataFormatFactory(){

            public DataFormat newInstance() {
                CamelContextAware contextAware;
                PGPDataFormat dataformat = new PGPDataFormat();
                if (CamelContextAware.class.isAssignableFrom(PGPDataFormat.class) && (contextAware = (CamelContextAware)CamelContextAware.class.cast(dataformat)) != null) {
                    contextAware.setCamelContext(PGPDataFormatAutoConfiguration.this.camelContext);
                }
                try {
                    HashMap parameters = new HashMap();
                    IntrospectionSupport.getProperties((Object)((Object)PGPDataFormatAutoConfiguration.this.configuration), parameters, null, (boolean)false);
                    CamelPropertiesHelper.setCamelProperties((CamelContext)PGPDataFormatAutoConfiguration.this.camelContext, (Object)dataformat, parameters, (boolean)false);
                }
                catch (Exception e) {
                    throw new RuntimeCamelException((Throwable)e);
                }
                if (ObjectHelper.isNotEmpty((Object)PGPDataFormatAutoConfiguration.this.customizers)) {
                    for (DataFormatCustomizer customizer : PGPDataFormatAutoConfiguration.this.customizers) {
                        boolean useCustomizer = customizer instanceof HasId ? HierarchicalPropertiesEvaluator.evaluate((Environment)PGPDataFormatAutoConfiguration.this.applicationContext.getEnvironment(), (String[])new String[]{"camel.dataformat.customizer", "camel.dataformat.pgp.customizer", ((HasId)customizer).getId()}) : HierarchicalPropertiesEvaluator.evaluate((Environment)PGPDataFormatAutoConfiguration.this.applicationContext.getEnvironment(), (String[])new String[]{"camel.dataformat.customizer", "camel.dataformat.pgp.customizer"});
                        if (!useCustomizer) continue;
                        LOGGER.debug("Configure dataformat {}, with customizer {}", (Object)dataformat, (Object)customizer);
                        customizer.customize((DataFormat)dataformat);
                    }
                }
                return dataformat;
            }
        };
    }

    static class GroupConditions
    extends GroupCondition {
        public GroupConditions() {
            super("camel.dataformat", "camel.dataformat.pgp");
        }
    }
}

