/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.schematron.processor;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Templates;
import org.apache.camel.component.schematron.exception.SchematronConfigException;
import org.apache.camel.component.schematron.processor.SchematronProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class SchematronProcessorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SchematronProcessorFactory.class);

    private SchematronProcessorFactory() {
        throw new IllegalStateException();
    }

    public static SchematronProcessor newScehamtronEngine(Templates rules) {
        try {
            return new SchematronProcessor(SchematronProcessorFactory.getXMLReader(), rules);
        }
        catch (Exception e) {
            LOG.error("Failed to parse the configuration file");
            throw new SchematronConfigException(e);
        }
    }

    private static XMLReader getXMLReader() throws ParserConfigurationException, SAXException {
        SAXParserFactory fac = SAXParserFactory.newInstance();
        try {
            fac.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            fac.setFeature("http://xml.org/sax/features/external-general-entities", false);
            fac.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            fac.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException | SAXException exception) {
            // empty catch block
        }
        fac.setValidating(false);
        SAXParser parser = fac.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        return reader;
    }
}

