/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.olingo2;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.olingo.odata2.api.ep.entry.EntryMetadata;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.ep.feed.FeedMetadata;
import org.apache.olingo.odata2.api.ep.feed.ODataFeed;

public class Olingo2Index {
    private Set<Integer> resultIndex = new HashSet<Integer>();

    private int hash(EntryMetadata metadata) {
        int prime = 31;
        int result = 1;
        result = 31 * result + (metadata.getId() == null ? 0 : metadata.getId().hashCode());
        result = 31 * result + (metadata.getUri() == null ? 0 : metadata.getUri().hashCode());
        return result;
    }

    private int hash(ODataEntry entry) {
        int prime = 31;
        int result = 1;
        result = 31 * result + (entry.getMetadata() == null ? 0 : this.hash(entry.getMetadata()));
        result = 31 * result + (entry.getProperties() == null ? 0 : entry.getProperties().hashCode());
        return result;
    }

    private Object filter(Object o) {
        if (o == null || this.resultIndex.contains(o.hashCode())) {
            return null;
        }
        return o;
    }

    private void indexDefault(Object o) {
        if (o == null) {
            return;
        }
        this.resultIndex.add(o.hashCode());
    }

    private Object filter(ODataEntry entry) {
        if (entry == null || this.resultIndex.contains(this.hash(entry))) {
            return null;
        }
        return entry;
    }

    private void index(ODataEntry entry) {
        if (entry == null) {
            return;
        }
        this.resultIndex.add(this.hash(entry));
    }

    private Iterable<?> filter(Iterable<?> iterable) {
        ArrayList filtered = new ArrayList();
        if (iterable == null) {
            return filtered;
        }
        for (Object o : iterable) {
            if (this.resultIndex.contains(o.hashCode())) continue;
            filtered.add(o);
        }
        return filtered;
    }

    private void index(Iterable<?> iterable) {
        if (iterable == null) {
            return;
        }
        for (Object o : iterable) {
            this.resultIndex.add(o.hashCode());
        }
    }

    private ODataFeed filter(ODataFeed odataFeed) {
        if (odataFeed == null) {
            return new EmptyODataFeed();
        }
        List entries = odataFeed.getEntries();
        if (entries.isEmpty()) {
            return odataFeed;
        }
        ArrayList copyEntries = new ArrayList();
        copyEntries.addAll(entries);
        for (ODataEntry entry : copyEntries) {
            if (!this.resultIndex.contains(this.hash(entry))) continue;
            entries.remove(entry);
        }
        return odataFeed;
    }

    private void index(ODataFeed odataFeed) {
        if (odataFeed == null) {
            return;
        }
        for (ODataEntry entry : odataFeed.getEntries()) {
            this.resultIndex.add(this.hash(entry));
        }
    }

    public void index(Object result) {
        if (result instanceof ODataFeed) {
            this.index((ODataFeed)result);
        } else if (result instanceof Iterable) {
            this.index((Iterable)result);
        } else if (result instanceof ODataEntry) {
            this.index((ODataEntry)result);
        } else {
            this.indexDefault(result);
        }
    }

    public Object filterResponse(Object response) {
        if (response instanceof ODataFeed) {
            response = this.filter((ODataFeed)response);
        } else if (response instanceof Iterable) {
            response = this.filter((Iterable)response);
        } else if (response.getClass().isArray()) {
            ArrayList<Object> result = new ArrayList<Object>();
            int size = Array.getLength(response);
            for (int i = 0; i < size; ++i) {
                result.add(Array.get(response, i));
            }
            response = this.filter(result);
        } else {
            response = response instanceof ODataEntry ? this.filter((ODataEntry)response) : this.filter(response);
        }
        return response;
    }

    private class EmptyODataFeed
    implements ODataFeed {
        private EmptyODataFeed() {
        }

        public List<ODataEntry> getEntries() {
            return Collections.emptyList();
        }

        public FeedMetadata getFeedMetadata() {
            return new FeedMetadata(){

                public String getDeltaLink() {
                    return null;
                }

                public Integer getInlineCount() {
                    return 0;
                }

                public String getNextLink() {
                    return null;
                }
            };
        }
    }
}

