/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.corda;

import java.net.URI;
import java.net.URISyntaxException;
import net.corda.client.rpc.CordaRPCClient;
import net.corda.client.rpc.CordaRPCConnection;
import net.corda.core.messaging.CordaRPCOps;
import net.corda.core.utilities.NetworkHostAndPort;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.corda.CordaComponent;
import org.apache.camel.component.corda.CordaConfiguration;
import org.apache.camel.component.corda.CordaConsumer;
import org.apache.camel.component.corda.CordaProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriPath;

@UriEndpoint(firstVersion="2.23.0", scheme="corda", title="corda", syntax="corda:url", consumerClass=CordaConsumer.class, label="corda,blockchain")
public class CordaEndpoint
extends DefaultEndpoint {
    @UriPath(description="URL to the corda node")
    @Metadata(required="true")
    private CordaConfiguration configuration;
    private CordaRPCConnection rpcConnection;
    private CordaRPCOps proxy;

    public CordaEndpoint(String uri, String remaining, CordaComponent component, CordaConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
        try {
            URI nodeURI = new URI(uri);
            configuration.setHost(nodeURI.getHost());
            configuration.setPort(nodeURI.getPort());
            if (nodeURI.getUserInfo() != null) {
                String[] creds = nodeURI.getUserInfo().split(":");
                if (configuration.getUsername() == null) {
                    configuration.setUsername(creds[0]);
                }
                if (configuration.getPassword() == null) {
                    configuration.setPassword(creds.length > 1 ? creds[1] : "");
                }
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI: " + remaining, e);
        }
    }

    public Producer createProducer() throws Exception {
        return new CordaProducer(this, this.configuration, this.proxy);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        CordaConsumer consumer = new CordaConsumer(this, processor, this.configuration, this.proxy);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    protected void doStart() throws Exception {
        NetworkHostAndPort rpcAddress = new NetworkHostAndPort(this.configuration.getHost(), this.configuration.getPort());
        CordaRPCClient rpcClient = new CordaRPCClient(rpcAddress);
        this.rpcConnection = rpcClient.start(this.configuration.getUsername(), this.configuration.getPassword());
        this.proxy = this.rpcConnection.getProxy();
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.rpcConnection != null) {
            this.rpcConnection.notifyServerAndClose();
        }
        super.doStop();
    }

    public boolean isSingleton() {
        return true;
    }
}

