/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.opentracing.propagation;

import io.opentracing.propagation.TextMap;
import java.util.Iterator;
import java.util.Map;

public final class CamelMessagingHeadersInjectAdapter
implements TextMap {
    static final String JMS_DASH = "_$dash$_";
    private final Map<String, Object> map;
    private final boolean jmsEncoding;

    public CamelMessagingHeadersInjectAdapter(Map<String, Object> map, boolean jmsEncoding) {
        this.map = map;
        this.jmsEncoding = jmsEncoding;
    }

    public Iterator<Map.Entry<String, String>> iterator() {
        throw new UnsupportedOperationException("CamelHeadersInjectAdapter should only be used with Tracer.inject()");
    }

    public void put(String key, String value) {
        if (!key.startsWith("Camel")) {
            this.map.put(this.encodeDash(key), value);
        }
    }

    private String encodeDash(String key) {
        if (key == null || key.isEmpty() || !this.jmsEncoding) {
            return key;
        }
        return key.replace("-", JMS_DASH);
    }
}

