/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.opentracing.propagation;

import io.opentracing.propagation.TextMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class CamelMessagingHeadersExtractAdapter
implements TextMap {
    private final Map<String, String> map = new HashMap<String, String>();
    private final boolean jmsEncoding;

    public CamelMessagingHeadersExtractAdapter(Map<String, Object> map, boolean jmsEncoding) {
        this.jmsEncoding = jmsEncoding;
        map.entrySet().stream().filter(e -> e.getValue() instanceof String).forEach(e -> this.map.put(this.decodeDash((String)e.getKey()), (String)e.getValue()));
    }

    public Iterator<Map.Entry<String, String>> iterator() {
        return this.map.entrySet().iterator();
    }

    public void put(String key, String value) {
        throw new UnsupportedOperationException("CamelMessagingHeadersExtractAdapter should only be used with Tracer.extract()");
    }

    private String decodeDash(String key) {
        if (this.jmsEncoding) {
            return key.replace("_$dash$_", "-");
        }
        return key;
    }
}

