/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.opentracing.decorators;

import io.opentracing.Span;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.opentracing.decorators.AbstractMessagingSpanDecorator;

public class KafkaSpanDecorator
extends AbstractMessagingSpanDecorator {
    public static final String KAFKA_PARTITION_TAG = "kafka.partition";
    public static final String KAFKA_PARTITION_KEY_TAG = "kafka.partition.key";
    public static final String KAFKA_KEY_TAG = "kafka.key";
    public static final String KAFKA_OFFSET_TAG = "kafka.offset";
    protected static final String PARTITION_KEY = "kafka.PARTITION_KEY";
    protected static final String PARTITION = "kafka.PARTITION";
    protected static final String KEY = "kafka.KEY";
    protected static final String TOPIC = "kafka.TOPIC";
    protected static final String OFFSET = "kafka.OFFSET";

    @Override
    public String getComponent() {
        return "kafka";
    }

    @Override
    public String getDestination(Exchange exchange, Endpoint endpoint) {
        String topic = (String)exchange.getIn().getHeader(TOPIC);
        if (topic == null) {
            Map<String, String> queryParameters = KafkaSpanDecorator.toQueryParameters(endpoint.getEndpointUri());
            topic = queryParameters.get("topic");
        }
        return topic != null ? topic : super.getDestination(exchange, endpoint);
    }

    @Override
    public void pre(Span span, Exchange exchange, Endpoint endpoint) {
        String offset;
        String key;
        String partitionKey;
        super.pre(span, exchange, endpoint);
        String partition = this.getValue(exchange, PARTITION, Integer.class);
        if (partition != null) {
            span.setTag(KAFKA_PARTITION_TAG, partition);
        }
        if ((partitionKey = (String)exchange.getIn().getHeader(PARTITION_KEY)) != null) {
            span.setTag(KAFKA_PARTITION_KEY_TAG, partitionKey);
        }
        if ((key = (String)exchange.getIn().getHeader(KEY)) != null) {
            span.setTag(KAFKA_KEY_TAG, key);
        }
        if ((offset = this.getValue(exchange, OFFSET, Long.class)) != null) {
            span.setTag(KAFKA_OFFSET_TAG, offset);
        }
    }

    private <T> String getValue(Exchange exchange, String header, Class<T> type) {
        Object partition = exchange.getIn().getHeader(header, type);
        return partition != null ? String.valueOf(partition) : (String)exchange.getIn().getHeader(header, String.class);
    }
}

