/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp;

import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.mllp.MllpComponent;
import org.apache.camel.component.mllp.MllpProtocolConstants;
import org.apache.camel.component.mllp.internal.Hl7Util;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriParams
public class MllpConfiguration
implements Cloneable {
    static final Logger LOG = LoggerFactory.getLogger(MllpConfiguration.class);
    @UriParam(label="consumer", defaultValue="true")
    boolean bridgeErrorHandler = true;
    @UriParam(label="consumer,advanced", defaultValue="InOut")
    ExchangePattern exchangePattern = ExchangePattern.InOut;
    @UriParam(label="advanced", defaultValue="true")
    boolean synchronous = true;
    @UriParam(label="advanced,consumer,tcp", defaultValue="5")
    Integer backlog = 5;
    @UriParam(label="advanced,consumer,tcp,timeout", defaultValue="30000")
    int bindTimeout = 30000;
    @UriParam(label="advanced,consumer,tcp,timeout", defaultValue="5000")
    int bindRetryInterval = 5000;
    @UriParam(label="advanced,consumer,tcp", defaultValue="false")
    boolean lenientBind;
    @UriParam(label="advanced,consumer,tcp,timeout", defaultValue="60000")
    int acceptTimeout = 60000;
    @UriParam(label="advanced,producer,tcp,timeout", defaultValue="30000")
    int connectTimeout = 30000;
    @UriParam(label="advanced,tcp,timeout", defaultValue="15000")
    int receiveTimeout = 15000;
    @UriParam(label="advanced,consumer,tcp", defaultValue="5")
    int maxConcurrentConsumers = 5;
    @Deprecated
    @UriParam(label="advanced,consumer,tcp,timeout", defaultValue="null")
    Integer maxReceiveTimeouts;
    @UriParam(label="advanced,tcp,timeout", defaultValue="null")
    Integer idleTimeout;
    @UriParam(label="advanced,tcp,timeout", defaultValue="5000")
    int readTimeout = 5000;
    @UriParam(label="advanced,producer,tcp", defaultValue="true")
    Boolean keepAlive = true;
    @UriParam(label="advanced,producer,tcp", defaultValue="true")
    Boolean tcpNoDelay = true;
    @UriParam(label="advanced,consumer,tcp", defaultValue="false")
    Boolean reuseAddress = false;
    @UriParam(label="advanced,tcp", defaultValue="8192")
    Integer receiveBufferSize = 8192;
    @UriParam(label="advanced,tcp", defaultValue="8192")
    Integer sendBufferSize = 8192;
    @UriParam(defaultValue="true")
    boolean autoAck = true;
    @UriParam(defaultValue="true")
    boolean hl7Headers = true;
    @UriParam(defaultValue="false")
    @Deprecated
    boolean bufferWrites;
    @UriParam(defaultValue="true")
    boolean requireEndOfData = true;
    @UriParam(defaultValue="true")
    boolean stringPayload = true;
    @UriParam(defaultValue="false")
    boolean validatePayload;
    @UriParam(label="codec")
    String charsetName;

    public MllpConfiguration() {
    }

    public MllpConfiguration(MllpConfiguration source) {
        this.copy(source);
    }

    public static void copy(MllpConfiguration source, MllpConfiguration target) {
        if (source == null) {
            LOG.warn("Values were not copied by MllpConfiguration.copy(MllpConfiguration source, MllpConfiguration target) - source argument is null");
        } else if (target == null) {
            LOG.warn("Values were not copied by MllpConfiguration.copy(MllpConfiguration source, MllpConfiguration target) - target argument is null");
        } else {
            target.bridgeErrorHandler = source.bridgeErrorHandler;
            target.exchangePattern = source.exchangePattern;
            target.synchronous = source.synchronous;
            target.backlog = source.backlog;
            target.bindTimeout = source.bindTimeout;
            target.bindRetryInterval = source.bindRetryInterval;
            target.acceptTimeout = source.acceptTimeout;
            target.connectTimeout = source.connectTimeout;
            target.receiveTimeout = source.receiveTimeout;
            target.idleTimeout = source.idleTimeout;
            target.readTimeout = source.readTimeout;
            target.keepAlive = source.keepAlive;
            target.tcpNoDelay = source.tcpNoDelay;
            target.reuseAddress = source.reuseAddress;
            target.receiveBufferSize = source.receiveBufferSize;
            target.sendBufferSize = source.sendBufferSize;
            target.autoAck = source.autoAck;
            target.hl7Headers = source.hl7Headers;
            target.bufferWrites = source.bufferWrites;
            target.requireEndOfData = source.requireEndOfData;
            target.stringPayload = source.stringPayload;
            target.validatePayload = source.validatePayload;
            target.charsetName = source.charsetName;
            target.maxConcurrentConsumers = source.maxConcurrentConsumers;
        }
    }

    public MllpConfiguration copy() {
        MllpConfiguration target = new MllpConfiguration();
        MllpConfiguration.copy(this, target);
        return target;
    }

    public void copy(MllpConfiguration source) {
        MllpConfiguration.copy(source, this);
    }

    public boolean isBridgeErrorHandler() {
        return this.bridgeErrorHandler;
    }

    public void setBridgeErrorHandler(boolean bridgeErrorHandler) {
        this.bridgeErrorHandler = bridgeErrorHandler;
    }

    public ExchangePattern getExchangePattern() {
        return this.exchangePattern;
    }

    public void setExchangePattern(ExchangePattern exchangePattern) {
        this.exchangePattern = exchangePattern;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
    }

    public boolean hasCharsetName() {
        return this.charsetName != null && !this.charsetName.isEmpty();
    }

    public String getCharsetName() {
        if (this.hasCharsetName()) {
            try {
                if (Charset.isSupported(this.charsetName)) {
                    return this.charsetName;
                }
                LOG.warn("Unsupported character set name '{}' configured for the MLLP Endpoint  - returning default charset name {}", (Object)this.charsetName, (Object)MllpComponent.getDefaultCharset());
            }
            catch (Exception charsetEx) {
                LOG.warn("Ignoring exception determining character set for name '{}' configured for the MLLP Endpoint - returning default charset name {}", new Object[]{this.charsetName, MllpComponent.getDefaultCharset(), charsetEx});
            }
        }
        return MllpComponent.getDefaultCharset().name();
    }

    public Charset getCharset() {
        if (this.hasCharsetName()) {
            try {
                if (Charset.isSupported(this.charsetName)) {
                    return Charset.forName(this.charsetName);
                }
                LOG.warn("Unsupported character set name '{}' configured for the MLLP Endpoint - returning default charset {}", (Object)this.charsetName, (Object)MllpComponent.getDefaultCharset());
            }
            catch (Exception charsetEx) {
                LOG.warn("Ignoring exception determining character set for name '{}' configured for the MLLP Endpoint - returning default charset {}", new Object[]{this.charsetName, MllpComponent.getDefaultCharset(), charsetEx});
            }
        }
        return MllpComponent.getDefaultCharset();
    }

    public Charset getCharset(Exchange exchange) {
        String exchangeCharsetName = IOHelper.getCharsetName((Exchange)exchange, (boolean)false);
        if (exchangeCharsetName != null && !exchangeCharsetName.isEmpty()) {
            try {
                if (Charset.isSupported(exchangeCharsetName)) {
                    return Charset.forName(exchangeCharsetName);
                }
                LOG.warn("Unsupported character set name '{}' specified in the Exchange - checking for configured character set", (Object)exchangeCharsetName);
            }
            catch (Exception charsetEx) {
                LOG.warn("Ignoring exception determining character set for name '{}' specified in the Exchange - checking for configured character set", (Object)exchangeCharsetName, (Object)charsetEx);
            }
        }
        return this.getCharset();
    }

    public Charset getCharset(Exchange exchange, byte[] hl7Bytes) {
        String msh18;
        String exchangeCharsetName = IOHelper.getCharsetName((Exchange)exchange, (boolean)false);
        if (exchangeCharsetName != null && !exchangeCharsetName.isEmpty()) {
            try {
                if (Charset.isSupported(exchangeCharsetName)) {
                    return Charset.forName(exchangeCharsetName);
                }
                LOG.warn("Unsupported character set name '{}' specified in the Exchange - checking for configured character set", (Object)exchangeCharsetName);
            }
            catch (Exception charsetEx) {
                LOG.warn("Ignoring exception determining character set for name '{}' specified in the Exchange - checking for configured character set", (Object)exchangeCharsetName, (Object)charsetEx);
            }
        }
        if (this.hasCharsetName()) {
            try {
                if (Charset.isSupported(this.charsetName)) {
                    return Charset.forName(this.charsetName);
                }
                LOG.warn("Unsupported character set name '{}' configured for the MLLP Endpoint - checking for character set in payload", (Object)this.charsetName);
            }
            catch (Exception charsetEx) {
                LOG.warn("Ignoring exception determining character set for name '{}' configured for the MLLP Endpoint - checking for character set in payload", (Object)this.charsetName, (Object)charsetEx);
            }
        }
        if ((msh18 = Hl7Util.findMsh18(hl7Bytes)) != null && !msh18.isEmpty()) {
            if (MllpProtocolConstants.MSH18_VALUES.containsKey(msh18)) {
                return MllpProtocolConstants.MSH18_VALUES.get(msh18);
            }
            try {
                if (Charset.isSupported(msh18)) {
                    return Charset.forName(msh18);
                }
                LOG.info("Unsupported character set name '{}' found in MSH-18 - using default character set {}", (Object)msh18, (Object)MllpComponent.getDefaultCharset());
            }
            catch (Exception charsetEx) {
                LOG.info("Ignoring exception encountered determining character set for for name '{}' found in MSH-18 - using default character set {}", new Object[]{msh18, MllpComponent.getDefaultCharset(), charsetEx});
            }
        }
        return MllpComponent.getDefaultCharset();
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public boolean hasBacklog() {
        return this.backlog != null && this.backlog > 0;
    }

    public Integer getBacklog() {
        return this.backlog;
    }

    public void setBacklog(Integer backlog) {
        this.backlog = backlog;
    }

    public int getBindTimeout() {
        return this.bindTimeout;
    }

    public void setBindTimeout(int bindTimeout) {
        this.bindTimeout = bindTimeout;
    }

    public int getBindRetryInterval() {
        return this.bindRetryInterval;
    }

    public void setBindRetryInterval(int bindRetryInterval) {
        this.bindRetryInterval = bindRetryInterval;
    }

    public int getAcceptTimeout() {
        return this.acceptTimeout;
    }

    public boolean isLenientBind() {
        return this.lenientBind;
    }

    public void setLenientBind(boolean lenientBind) {
        this.lenientBind = lenientBind;
    }

    public void setAcceptTimeout(int acceptTimeout) {
        this.acceptTimeout = acceptTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setReceiveTimeout(int receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public int getMaxConcurrentConsumers() {
        return this.maxConcurrentConsumers;
    }

    public void setMaxConcurrentConsumers(int maxConcurrentConsumers) {
        this.maxConcurrentConsumers = maxConcurrentConsumers;
    }

    @Deprecated
    public boolean hasMaxReceiveTimeouts() {
        return this.maxReceiveTimeouts != null;
    }

    @Deprecated
    public Integer getMaxReceiveTimeouts() {
        return this.maxReceiveTimeouts;
    }

    @Deprecated
    public void setMaxReceiveTimeouts(Integer maxReceiveTimeouts) {
        this.maxReceiveTimeouts = maxReceiveTimeouts;
    }

    public boolean hasIdleTimeout() {
        return this.idleTimeout != null && this.idleTimeout > 0;
    }

    public Integer getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(Integer idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public boolean hasKeepAlive() {
        return this.keepAlive != null;
    }

    public Boolean getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(Boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean hasTcpNoDelay() {
        return this.tcpNoDelay != null;
    }

    public Boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(Boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public boolean hasReuseAddress() {
        return this.reuseAddress != null;
    }

    public Boolean getReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(Boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public boolean hasReceiveBufferSize() {
        return this.receiveBufferSize != null && this.receiveBufferSize > 0;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(Integer receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public boolean hasSendBufferSize() {
        return this.sendBufferSize != null && this.sendBufferSize > 0;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(Integer sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public boolean isAutoAck() {
        return this.autoAck;
    }

    public void setAutoAck(boolean autoAck) {
        this.autoAck = autoAck;
    }

    public boolean isHl7Headers() {
        return this.hl7Headers;
    }

    public boolean getHl7Headers() {
        return this.isHl7Headers();
    }

    public void setHl7Headers(boolean hl7Headers) {
        this.hl7Headers = hl7Headers;
    }

    public boolean isRequireEndOfData() {
        return this.requireEndOfData;
    }

    public void setRequireEndOfData(boolean requireEndOfData) {
        this.requireEndOfData = requireEndOfData;
    }

    public boolean isStringPayload() {
        return this.stringPayload;
    }

    public void setStringPayload(boolean stringPayload) {
        this.stringPayload = stringPayload;
    }

    public boolean isValidatePayload() {
        return this.validatePayload;
    }

    public void setValidatePayload(boolean validatePayload) {
        this.validatePayload = validatePayload;
    }

    public boolean isBufferWrites() {
        return this.bufferWrites;
    }

    @Deprecated
    public void setBufferWrites(boolean bufferWrites) {
        this.bufferWrites = bufferWrites;
    }

    public int hashCode() {
        return Objects.hash(this.bridgeErrorHandler, this.exchangePattern, this.synchronous, this.backlog, this.bindTimeout, this.bindRetryInterval, this.acceptTimeout, this.connectTimeout, this.receiveTimeout, this.maxConcurrentConsumers, this.maxReceiveTimeouts, this.idleTimeout, this.readTimeout, this.keepAlive, this.tcpNoDelay, this.reuseAddress, this.receiveBufferSize, this.sendBufferSize, this.autoAck, this.hl7Headers, this.bufferWrites, this.requireEndOfData, this.stringPayload, this.validatePayload, this.charsetName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MllpConfiguration)) {
            return false;
        }
        MllpConfiguration rhs = (MllpConfiguration)o;
        return this.bridgeErrorHandler == rhs.bridgeErrorHandler && this.exchangePattern == rhs.exchangePattern && this.synchronous == rhs.synchronous && this.bindTimeout == rhs.bindTimeout && this.bindRetryInterval == rhs.bindRetryInterval && this.acceptTimeout == rhs.acceptTimeout && this.connectTimeout == rhs.connectTimeout && this.receiveTimeout == rhs.receiveTimeout && this.readTimeout == rhs.readTimeout && this.autoAck == rhs.autoAck && this.hl7Headers == rhs.hl7Headers && this.bufferWrites == rhs.bufferWrites && this.requireEndOfData == rhs.requireEndOfData && this.stringPayload == rhs.stringPayload && this.validatePayload == rhs.validatePayload && Objects.equals(this.backlog, rhs.backlog) && Objects.equals(this.maxConcurrentConsumers, rhs.maxConcurrentConsumers) && Objects.equals(this.maxReceiveTimeouts, rhs.maxReceiveTimeouts) && Objects.equals(this.idleTimeout, rhs.idleTimeout) && Objects.equals(this.keepAlive, rhs.keepAlive) && Objects.equals(this.tcpNoDelay, rhs.tcpNoDelay) && Objects.equals(this.reuseAddress, rhs.reuseAddress) && Objects.equals(this.receiveBufferSize, rhs.receiveBufferSize) && Objects.equals(this.sendBufferSize, rhs.sendBufferSize) && Objects.equals(this.charsetName, rhs.charsetName);
    }

    public String toString() {
        return "MllpConfiguration{bridgeErrorHandler=" + this.bridgeErrorHandler + ", exchangePattern=" + this.exchangePattern + ", synchronous=" + this.synchronous + ", backlog=" + this.backlog + ", bindTimeout=" + this.bindTimeout + ", bindRetryInterval=" + this.bindRetryInterval + ", acceptTimeout=" + this.acceptTimeout + ", connectTimeout=" + this.connectTimeout + ", receiveTimeout=" + this.receiveTimeout + ", maxConcurrentConsumers=" + this.maxConcurrentConsumers + ", maxReceiveTimeouts=" + this.maxReceiveTimeouts + ", idleTimeout=" + this.idleTimeout + ", readTimeout=" + this.readTimeout + ", keepAlive=" + this.keepAlive + ", tcpNoDelay=" + this.tcpNoDelay + ", reuseAddress=" + this.reuseAddress + ", receiveBufferSize=" + this.receiveBufferSize + ", sendBufferSize=" + this.sendBufferSize + ", autoAck=" + this.autoAck + ", hl7Headers=" + this.hl7Headers + ", bufferWrites=" + this.bufferWrites + ", requireEndOfData=" + this.requireEndOfData + ", stringPayload=" + this.stringPayload + ", validatePayload=" + this.validatePayload + ", charsetName='" + this.charsetName + '\'' + '}';
    }
}

