/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.processor;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Service;

public interface SalesforceProcessor
extends Service {
    public boolean process(Exchange var1, AsyncCallback var2);

    default public Map<String, List<String>> determineHeaders(Exchange exchange) {
        Message inboundMessage = exchange.getIn();
        Map headers = inboundMessage.getHeaders();
        HashMap<String, List<String>> answer = new HashMap<String, List<String>>();
        for (String headerName : headers.keySet()) {
            String headerNameLowercase = headerName.toLowerCase(Locale.US);
            if (!headerNameLowercase.startsWith("sforce") && !headerNameLowercase.startsWith("x-sfdc")) continue;
            Object headerValue = inboundMessage.getHeader(headerName);
            if (headerValue instanceof String) {
                answer.put(headerName, Collections.singletonList((String)headerValue));
                continue;
            }
            if (headerValue instanceof String[]) {
                answer.put(headerName, Arrays.asList((String[])headerValue));
                continue;
            }
            if (headerValue instanceof Collection) {
                Collection collection = (Collection)headerValue;
                answer.put(headerName, collection.stream().map(String.class::cast).collect(Collectors.toList()));
                continue;
            }
            answer.put(headerName, Collections.singletonList(String.valueOf(headerValue)));
        }
        return answer;
    }
}

