/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api.utils;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.ZonedDateTimeSerializer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.camel.component.salesforce.api.utils.DateTimeHandling;
import org.apache.camel.component.salesforce.api.utils.InstantDeserializer;
import org.apache.camel.component.salesforce.api.utils.InstantSerializer;
import org.apache.camel.component.salesforce.api.utils.LocalDateTimeDeserializer;
import org.apache.camel.component.salesforce.api.utils.LocalDateTimeSerializer;
import org.apache.camel.component.salesforce.api.utils.OffsetDateTimeDeserializer;
import org.apache.camel.component.salesforce.api.utils.OffsetDateTimeSerializer;
import org.apache.camel.component.salesforce.api.utils.OffsetTimeDeserializer;
import org.apache.camel.component.salesforce.api.utils.OffsetTimeSerializer;
import org.apache.camel.component.salesforce.api.utils.ZonedDateTimeDeserializer;

public class TimeModule
extends SimpleModule {
    private static final LocalDateDeserializer LOCAL_DATE_DESERIALIZER = new LocalDateDeserializer(DateTimeFormatter.ISO_DATE);
    private static final LocalDateSerializer LOCAL_DATE_SERIALIZER = new LocalDateSerializer(DateTimeFormatter.ISO_DATE);
    private static final long serialVersionUID = 1L;
    private static final ZonedDateTimeSerializer ZONED_DATE_TIME_SERIALIZER = new ZonedDateTimeSerializer(DateTimeHandling.ISO_OFFSET_DATE_TIME);
    private final JavaTimeModule delegate = new JavaTimeModule();

    public TimeModule() {
        this.addSerializer(LocalDate.class, (JsonSerializer)LOCAL_DATE_SERIALIZER);
        this.addDeserializer(LocalDate.class, (JsonDeserializer)LOCAL_DATE_DESERIALIZER);
        this.addSerializer(LocalDateTime.class, LocalDateTimeSerializer.INSTANCE);
        this.addDeserializer(LocalDateTime.class, LocalDateTimeDeserializer.INSTANCE);
        this.addSerializer(OffsetDateTime.class, OffsetDateTimeSerializer.INSTANCE);
        this.addDeserializer(OffsetDateTime.class, OffsetDateTimeDeserializer.INSTANCE);
        this.addSerializer(ZonedDateTime.class, (JsonSerializer)ZONED_DATE_TIME_SERIALIZER);
        this.addDeserializer(ZonedDateTime.class, ZonedDateTimeDeserializer.INSTANCE);
        this.addSerializer(Instant.class, InstantSerializer.INSTANCE);
        this.addDeserializer(Instant.class, InstantDeserializer.INSTANCE);
        this.addSerializer(OffsetTime.class, OffsetTimeSerializer.INSTANCE);
        this.addDeserializer(OffsetTime.class, OffsetTimeDeserializer.INSTANCE);
    }

    public void setupModule(Module.SetupContext context) {
        this.delegate.setupModule(context);
        super.setupModule(context);
    }
}

