/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.iec60870;

import java.util.Objects;

public class ConnectionId {
    private final String host;
    private final int port;
    private final String connectionId;

    public ConnectionId(String host, int port, String connectionId) {
        Objects.requireNonNull(host);
        if (port <= 0) {
            throw new IllegalArgumentException("Port must be greater than 0");
        }
        this.host = host;
        this.port = port;
        this.connectionId = connectionId;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.connectionId == null ? 0 : this.connectionId.hashCode());
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + this.port;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectionId other = (ConnectionId)obj;
        if (this.connectionId == null ? other.connectionId != null : !this.connectionId.equals(other.connectionId)) {
            return false;
        }
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        return this.port == other.port;
    }
}

