/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atomix.client.multimap;

import io.atomix.collections.DistributedMultiMap;
import io.atomix.resource.ReadConsistency;
import io.atomix.resource.Resource;
import java.time.Duration;
import org.apache.camel.AsyncCallback;
import org.apache.camel.InvokeOnHeader;
import org.apache.camel.Message;
import org.apache.camel.component.atomix.client.AbstractAtomixClientProducer;
import org.apache.camel.component.atomix.client.multimap.AtomixMultiMapConfiguration;
import org.apache.camel.component.atomix.client.multimap.AtomixMultiMapEndpoint;
import org.apache.camel.util.ObjectHelper;

final class AtomixMultiMapProducer
extends AbstractAtomixClientProducer<AtomixMultiMapEndpoint, DistributedMultiMap> {
    private final AtomixMultiMapConfiguration configuration;

    protected AtomixMultiMapProducer(AtomixMultiMapEndpoint endpoint) {
        super(endpoint);
        this.configuration = endpoint.getConfiguration();
    }

    @InvokeOnHeader(value="PUT")
    boolean onPut(Message message, AsyncCallback callback) throws Exception {
        DistributedMultiMap map = (DistributedMultiMap)this.getResource(message);
        Object key = message.getHeader("CamelAtomixResourceKey", this.configuration::getKey, Object.class);
        Object val = message.getHeader("CamelAtomixResourceValue", () -> ((Message)message).getBody(), Object.class);
        long ttl = (Long)message.getHeader("CamelAtomixResourceTTL", this.configuration::getTtl, Long.TYPE);
        ObjectHelper.notNull((Object)key, (String)"CamelAtomixResourceKey");
        ObjectHelper.notNull((Object)val, (String)"CamelAtomixResourceValue");
        if (ttl > 0L) {
            map.put(key, val, Duration.ofMillis(ttl)).thenAccept(result -> this.processResult(message, callback, result));
        } else {
            map.put(key, val).thenAccept(result -> this.processResult(message, callback, result));
        }
        return false;
    }

    @InvokeOnHeader(value="GET")
    boolean onGet(Message message, AsyncCallback callback) throws Exception {
        DistributedMultiMap map = (DistributedMultiMap)this.getResource(message);
        Object key = message.getHeader("CamelAtomixResourceKey", this.configuration::getKey, Object.class);
        ReadConsistency consistency = (ReadConsistency)message.getHeader("CamelAtomixResourceReadConsistency", this.configuration::getReadConsistency, ReadConsistency.class);
        ObjectHelper.notNull((Object)key, (String)"CamelAtomixResourceKey");
        if (consistency != null) {
            map.get(key, consistency).thenAccept(result -> this.processResult(message, callback, result));
        } else {
            map.get(key).thenAccept(result -> this.processResult(message, callback, result));
        }
        return false;
    }

    @InvokeOnHeader(value="CLEAR")
    boolean onClear(Message message, AsyncCallback callback) throws Exception {
        DistributedMultiMap map = (DistributedMultiMap)this.getResource(message);
        map.clear().thenAccept(result -> this.processResult(message, callback, result));
        return false;
    }

    @InvokeOnHeader(value="SIZE")
    boolean onSize(Message message, AsyncCallback callback) throws Exception {
        DistributedMultiMap map = (DistributedMultiMap)this.getResource(message);
        ReadConsistency consistency = (ReadConsistency)message.getHeader("CamelAtomixResourceReadConsistency", this.configuration::getReadConsistency, ReadConsistency.class);
        Object key = message.getHeader("CamelAtomixResourceKey", () -> ((Message)message).getBody(), Object.class);
        if (consistency != null) {
            if (key != null) {
                map.size(key, consistency).thenAccept(result -> this.processResult(message, callback, result));
            } else {
                map.size(consistency).thenAccept(result -> this.processResult(message, callback, result));
            }
        } else if (key != null) {
            map.size(key).thenAccept(result -> this.processResult(message, callback, result));
        } else {
            map.size().thenAccept(result -> this.processResult(message, callback, result));
        }
        return false;
    }

    @InvokeOnHeader(value="IS_EMPTY")
    boolean onIsEmpty(Message message, AsyncCallback callback) throws Exception {
        DistributedMultiMap map = (DistributedMultiMap)this.getResource(message);
        ReadConsistency consistency = (ReadConsistency)message.getHeader("CamelAtomixResourceReadConsistency", this.configuration::getReadConsistency, ReadConsistency.class);
        if (consistency != null) {
            map.isEmpty(consistency).thenAccept(result -> this.processResult(message, callback, result));
        } else {
            map.isEmpty().thenAccept(result -> this.processResult(message, callback, result));
        }
        return false;
    }

    @InvokeOnHeader(value="CONTAINS_KEY")
    boolean onContainsKey(Message message, AsyncCallback callback) throws Exception {
        DistributedMultiMap map = (DistributedMultiMap)this.getResource(message);
        ReadConsistency consistency = (ReadConsistency)message.getHeader("CamelAtomixResourceReadConsistency", this.configuration::getReadConsistency, ReadConsistency.class);
        Object key = message.getHeader("CamelAtomixResourceKey", () -> ((Message)message).getBody(), Object.class);
        ObjectHelper.notNull((Object)key, (String)"CamelAtomixResourceKey");
        if (consistency != null) {
            map.containsKey(key, consistency).thenAccept(result -> this.processResult(message, callback, result));
        } else {
            map.containsKey(key).thenAccept(result -> this.processResult(message, callback, result));
        }
        return false;
    }

    @InvokeOnHeader(value="REMOVE")
    boolean onRemove(Message message, AsyncCallback callback) throws Exception {
        DistributedMultiMap map = (DistributedMultiMap)this.getResource(message);
        Object key = message.getHeader("CamelAtomixResourceKey", () -> ((Message)message).getBody(), Object.class);
        Object value = message.getHeader("CamelAtomixResourceValue", () -> ((Message)message).getBody(), Object.class);
        ObjectHelper.notNull((Object)key, (String)"CamelAtomixResourceKey");
        if (value != null) {
            map.remove(key, value).thenAccept(result -> this.processResult(message, callback, result));
        } else {
            map.remove(key).thenAccept(result -> this.processResult(message, callback, result));
        }
        return false;
    }

    @InvokeOnHeader(value="REMOVE_VALUE")
    boolean onRemoveValue(Message message, AsyncCallback callback) throws Exception {
        DistributedMultiMap map = (DistributedMultiMap)this.getResource(message);
        Object value = message.getHeader("CamelAtomixResourceValue", () -> ((Message)message).getBody(), Object.class);
        ObjectHelper.notNull((Object)value, (String)"CamelAtomixResourceValue");
        map.removeValue(value).thenAccept(result -> this.processResult(message, callback, result));
        return false;
    }

    @Override
    protected String getProcessorKey(Message message) {
        return (String)message.getHeader("CamelAtomixResourceAction", this.configuration::getDefaultAction, String.class);
    }

    @Override
    protected String getResourceName(Message message) {
        return (String)message.getHeader("CamelAtomixResourceName", ((AtomixMultiMapEndpoint)((Object)this.getAtomixEndpoint()))::getResourceName, String.class);
    }

    @Override
    protected DistributedMultiMap<Object, Object> createResource(String resourceName) {
        return (DistributedMultiMap)((AtomixMultiMapEndpoint)((Object)this.getAtomixEndpoint())).getAtomix().getMultiMap(resourceName, new DistributedMultiMap.Config(((AtomixMultiMapEndpoint)((Object)this.getAtomixEndpoint())).getConfiguration().getResourceOptions(resourceName)), new Resource.Options(((AtomixMultiMapEndpoint)((Object)this.getAtomixEndpoint())).getConfiguration().getResourceConfig(resourceName))).join();
    }
}

