/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.set;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ISet;
import java.util.Collection;
import org.apache.camel.Exchange;
import org.apache.camel.component.hazelcast.HazelcastComponentHelper;
import org.apache.camel.component.hazelcast.HazelcastDefaultEndpoint;
import org.apache.camel.component.hazelcast.HazelcastDefaultProducer;
import org.apache.camel.component.hazelcast.HazelcastOperation;

public class HazelcastSetProducer
extends HazelcastDefaultProducer {
    private final ISet<Object> set;

    public HazelcastSetProducer(HazelcastInstance hazelcastInstance, HazelcastDefaultEndpoint endpoint, String setName) {
        super(endpoint);
        this.set = hazelcastInstance.getSet(setName);
    }

    public void process(Exchange exchange) throws Exception {
        HazelcastOperation operation = this.lookupOperation(exchange);
        switch (operation) {
            case ADD: {
                this.add(exchange);
                break;
            }
            case REMOVE_VALUE: {
                this.remove(exchange);
                break;
            }
            case CLEAR: {
                this.clear();
                break;
            }
            case ADD_ALL: {
                this.addAll(exchange);
                break;
            }
            case REMOVE_ALL: {
                this.removeAll(exchange);
                break;
            }
            case RETAIN_ALL: {
                this.retainAll(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("The value '%s' is not allowed for parameter '%s' on the LIST cache.", new Object[]{operation, "CamelHazelcastOperationType"}));
            }
        }
        HazelcastComponentHelper.copyHeaders(exchange);
    }

    private void add(Exchange exchange) {
        Object body = exchange.getIn().getBody();
        this.set.add(body);
    }

    private void remove(Exchange exchange) {
        Object body = exchange.getIn().getBody();
        this.set.remove(body);
    }

    private void clear() {
        this.set.clear();
    }

    private void addAll(Exchange exchange) {
        Object body = exchange.getIn().getBody();
        this.set.addAll((Collection)body);
    }

    private void removeAll(Exchange exchange) {
        Object body = exchange.getIn().getBody();
        this.set.removeAll((Collection)body);
    }

    private void retainAll(Exchange exchange) {
        Object body = exchange.getIn().getBody();
        this.set.retainAll((Collection)body);
    }
}

