/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.websocket;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.component.websocket.DefaultWebsocket;
import org.apache.camel.component.websocket.WebsocketStore;

public class MemoryWebsocketStore
extends ConcurrentHashMap<String, DefaultWebsocket>
implements WebsocketStore {
    private static final long serialVersionUID = -2826843758230613922L;

    @Override
    public void add(DefaultWebsocket ws) {
        super.put(this.getKey(ws), ws);
    }

    @Override
    public void remove(DefaultWebsocket ws) {
        super.remove(this.getKey(ws));
    }

    @Override
    public void remove(String key) {
        super.remove(key);
    }

    @Override
    public DefaultWebsocket get(String key) {
        return (DefaultWebsocket)super.get(key);
    }

    @Override
    public Collection<DefaultWebsocket> getAll() {
        return super.values();
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
        this.clear();
    }

    private String getKey(DefaultWebsocket ws) {
        StringBuilder sb = new StringBuilder();
        if (ws.getConnectionKey() == null && ws.getPathSpec() == null) {
            return null;
        }
        if (ws.getConnectionKey() != null) {
            sb.append(ws.getConnectionKey());
        }
        if (ws.getPathSpec() != null) {
            sb.append(ws.getPathSpec());
        }
        return sb.toString();
    }
}

