/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.blob;

import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.StorageCredentialsAnonymous;
import com.microsoft.azure.storage.blob.CloudBlob;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.azure.blob.BlobServiceConfiguration;
import org.apache.camel.component.azure.blob.BlobServiceEndpoint;
import org.apache.camel.impl.UriEndpointComponent;

public class BlobServiceComponent
extends UriEndpointComponent {
    public BlobServiceComponent() {
        super(BlobServiceEndpoint.class);
    }

    public BlobServiceComponent(CamelContext context) {
        super(context, BlobServiceEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        BlobServiceConfiguration configuration = new BlobServiceConfiguration();
        this.setProperties(configuration, parameters);
        String[] parts = null;
        if (remaining != null) {
            parts = remaining.split("/");
        }
        if (parts == null || parts.length < 2) {
            throw new IllegalArgumentException("At least the account and container names must be specified.");
        }
        configuration.setAccountName(parts[0]);
        configuration.setContainerName(parts[1]);
        if (parts.length > 2) {
            StringBuilder sb = new StringBuilder();
            for (int i = 2; i < parts.length; ++i) {
                sb.append(parts[i]);
                if (i + 1 >= parts.length) continue;
                sb.append('/');
            }
            configuration.setBlobName(sb.toString());
        }
        this.checkCredentials(configuration);
        BlobServiceEndpoint endpoint = new BlobServiceEndpoint(uri, (Component)this, configuration);
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }

    private void checkCredentials(BlobServiceConfiguration cfg) {
        StorageCredentials creds;
        CloudBlob client = cfg.getAzureBlobClient();
        StorageCredentials storageCredentials = creds = client == null ? cfg.getCredentials() : client.getServiceClient().getCredentials();
        if ((creds == null || creds instanceof StorageCredentialsAnonymous) && !cfg.isPublicForRead()) {
            throw new IllegalArgumentException("Credentials must be specified.");
        }
    }
}

