/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.batch;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.spring.batch.SpringBatchEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.launch.JobLauncher;

public class SpringBatchComponent
extends UriEndpointComponent {
    private static final String DEFAULT_JOB_LAUNCHER_REF_NAME = "jobLauncher";
    private JobLauncher defaultResolvedJobLauncher;
    private Map<String, JobLauncher> allResolvedJobLaunchers;
    private JobLauncher jobLauncher;
    private JobRegistry jobRegistry;

    public SpringBatchComponent() {
        super(SpringBatchEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        SpringBatchEndpoint endpoint = new SpringBatchEndpoint(uri, (Component)this, this.jobLauncher, this.defaultResolvedJobLauncher, this.allResolvedJobLaunchers, remaining, this.jobRegistry);
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }

    protected void doStart() throws Exception {
        this.defaultResolvedJobLauncher = (JobLauncher)this.getCamelContext().getRegistry().lookupByNameAndType(DEFAULT_JOB_LAUNCHER_REF_NAME, JobLauncher.class);
        this.allResolvedJobLaunchers = this.getCamelContext().getRegistry().findByTypeWithName(JobLauncher.class);
    }

    public JobLauncher getJobLauncher() {
        return this.jobLauncher;
    }

    public void setJobLauncher(JobLauncher jobLauncher) {
        this.jobLauncher = jobLauncher;
    }

    public JobRegistry getJobRegistry() {
        return this.jobRegistry;
    }

    public void setJobRegistry(JobRegistry jobRegistry) {
        this.jobRegistry = jobRegistry;
    }
}

