/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hystrix.springboot;

import javax.servlet.Servlet;
import org.apache.camel.component.hystrix.metrics.servlet.HystrixEventStreamServlet;
import org.apache.camel.component.hystrix.springboot.HystrixMappingConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"camel.component.hystrix.mapping.enabled"}, matchIfMissing=true)
@ConditionalOnBean(type={"org.apache.camel.spring.boot.CamelAutoConfiguration"})
@AutoConfigureAfter(name={"org.apache.camel.spring.boot.CamelAutoConfiguration"})
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={HystrixMappingConfiguration.class})
public class HystrixMappingAutoConfiguration {
    @Bean
    ServletRegistrationBean servletRegistrationBean(HystrixMappingConfiguration config) {
        ServletRegistrationBean mapping = new ServletRegistrationBean();
        mapping.setServlet((Servlet)new HystrixEventStreamServlet());
        mapping.addUrlMappings(new String[]{config.getPath()});
        mapping.setName(config.getServletName());
        return mapping;
    }
}

