/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.websocket.jsr356;

import java.util.EventListener;
import java.util.Optional;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.websocket.server.ServerContainer;
import org.apache.camel.websocket.jsr356.JSR356WebSocketComponent;

public class ServletIntegration
implements ServletContainerInitializer {
    public void onStartup(Set<Class<?>> c, ServletContext ctx) {
        ctx.addListener((EventListener)new ServletContextListener(){

            public void contextInitialized(ServletContextEvent sce) {
                String contextPath = sce.getServletContext().getContextPath();
                Optional.ofNullable(sce.getServletContext().getAttribute(ServerContainer.class.getName())).map(ServerContainer.class::cast).ifPresent(container -> JSR356WebSocketComponent.registerServer(contextPath, container));
            }

            public void contextDestroyed(ServletContextEvent sce) {
                JSR356WebSocketComponent.unregisterServer(sce.getServletContext().getContextPath());
            }
        });
    }
}

