/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.as2.AS2Component;
import org.apache.camel.component.as2.AS2Configuration;
import org.apache.camel.component.as2.AS2Consumer;
import org.apache.camel.component.as2.AS2Producer;
import org.apache.camel.component.as2.api.AS2ClientConnection;
import org.apache.camel.component.as2.api.AS2ClientManager;
import org.apache.camel.component.as2.api.AS2ServerConnection;
import org.apache.camel.component.as2.api.AS2ServerManager;
import org.apache.camel.component.as2.internal.AS2ApiCollection;
import org.apache.camel.component.as2.internal.AS2ApiName;
import org.apache.camel.component.as2.internal.AS2ConnectionHelper;
import org.apache.camel.component.as2.internal.AS2PropertiesHelper;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.component.AbstractApiEndpoint;
import org.apache.camel.util.component.ApiMethod;
import org.apache.camel.util.component.ApiMethodPropertiesHelper;
import org.apache.camel.util.component.ApiName;

@UriEndpoint(scheme="as2", firstVersion="2.22.0", title="AS2", syntax="as2:apiName", consumerClass=AS2Consumer.class, label="AS2")
public class AS2Endpoint
extends AbstractApiEndpoint<AS2ApiName, AS2Configuration> {
    @UriParam
    private AS2Configuration configuration;
    private Object apiProxy;
    private AS2ClientConnection as2ClientConnection;
    private AS2ServerConnection as2ServerConnection;

    public AS2Endpoint(String uri, AS2Component component, AS2ApiName apiName, String methodName, AS2Configuration endpointConfiguration) {
        super(uri, (Component)component, (ApiName)apiName, methodName, AS2ApiCollection.getCollection().getHelper(apiName), (Object)endpointConfiguration);
        this.configuration = endpointConfiguration;
    }

    public AS2Configuration getAs2Configuration() {
        return this.configuration;
    }

    public AS2ClientConnection getAS2ClientConnection() {
        return this.as2ClientConnection;
    }

    public AS2ServerConnection getAS2ServerConnection() {
        return this.as2ServerConnection;
    }

    public Producer createProducer() throws Exception {
        return new AS2Producer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (this.inBody != null) {
            throw new IllegalArgumentException("Option inBody is not supported for consumer endpoint");
        }
        AS2Consumer consumer = new AS2Consumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    protected ApiMethodPropertiesHelper<AS2Configuration> getPropertiesHelper() {
        return AS2PropertiesHelper.getHelper();
    }

    protected String getThreadProfileName() {
        return "CamelAS2";
    }

    protected void afterConfigureProperties() {
        switch ((AS2ApiName)this.apiName) {
            case CLIENT: {
                this.createAS2ClientConnection();
                break;
            }
            case SERVER: {
                this.createAS2ServerConnection();
                break;
            }
        }
    }

    public Object getApiProxy(ApiMethod method, Map<String, Object> args) {
        if (this.apiProxy == null) {
            this.createApiProxy(method, args);
        }
        return this.apiProxy;
    }

    private void createApiProxy(ApiMethod method, Map<String, Object> args) {
        switch ((AS2ApiName)this.apiName) {
            case CLIENT: {
                this.apiProxy = new AS2ClientManager(this.getAS2ClientConnection());
                break;
            }
            case SERVER: {
                this.apiProxy = new AS2ServerManager(this.getAS2ServerConnection());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid API name " + this.apiName);
            }
        }
    }

    private void createAS2ClientConnection() {
        try {
            this.as2ClientConnection = AS2ConnectionHelper.createAS2ClientConnection(this.configuration);
        }
        catch (UnknownHostException e) {
            throw new RuntimeCamelException(String.format("Client HTTP connection failed: Unknown target host '%s'", this.configuration.getTargetHostname()));
        }
        catch (IOException e) {
            throw new RuntimeCamelException("Client HTTP connection failed", (Throwable)e);
        }
    }

    private void createAS2ServerConnection() {
        try {
            this.as2ServerConnection = AS2ConnectionHelper.createAS2ServerConnection(this.configuration);
        }
        catch (IOException e) {
            throw new RuntimeCamelException("Server HTTP connection failed", (Throwable)e);
        }
    }
}

