/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jbpm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.jbpm.JBPMConfiguration;
import org.apache.camel.component.jbpm.JBPMEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ExchangeHelper;
import org.kie.api.KieServices;
import org.kie.api.command.BatchExecutionCommand;
import org.kie.api.command.Command;
import org.kie.api.command.KieCommands;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.task.model.Task;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.api.model.instance.TaskAttachment;
import org.kie.server.api.model.instance.TaskInstance;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.ProcessServicesClient;
import org.kie.server.client.QueryServicesClient;
import org.kie.server.client.RuleServicesClient;
import org.kie.server.client.UserTaskServicesClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JBPMProducer
extends DefaultProducer {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(JBPMProducer.class);
    private static KieCommands commandsFactory = KieServices.get().getCommands();
    private JBPMConfiguration configuration;
    private KieServicesClient kieServicesClient;

    public JBPMProducer(JBPMEndpoint endpoint, KieServicesClient kieServicesClient) {
        super((Endpoint)endpoint);
        this.configuration = endpoint.getConfiguration();
        this.kieServicesClient = kieServicesClient;
    }

    protected void doStart() throws Exception {
        LOGGER.trace("starting producer");
        super.doStart();
        LOGGER.trace("started producer");
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    public void process(Exchange exchange) throws Exception {
        this.getOperation(exchange).execute(this.kieServicesClient, this.configuration, exchange);
    }

    Operation getOperation(Exchange exchange) {
        String operation = (String)exchange.getIn().getHeader("CamelJBPMOperation", String.class);
        if (operation == null && this.configuration.getOperation() != null) {
            operation = "CamelJBPMOperation" + this.configuration.getOperation();
        }
        if (operation == null) {
            operation = "CamelJBPMOperation" + (Object)((Object)Operation.startProcess);
        }
        LOGGER.trace("Operation: [{}]", (Object)operation);
        return Operation.valueOf(operation.substring("CamelJBPMOperation".length()));
    }

    static enum Operation {
        startProcess{

            @Override
            void execute(KieServicesClient kieServicesClient, JBPMConfiguration configuration, Exchange exchange) {
                ProcessServicesClient processClient = (ProcessServicesClient)kieServicesClient.getServicesClient(ProcessServicesClient.class);
                Long processInstance = processClient.startProcess(configuration.getDeploymentId(), this.getProcessId(configuration, exchange), this.getParameters(configuration, exchange));
                this.setResult(exchange, processInstance);
            }
        }
        ,
        abortProcessInstance{

            @Override
            void execute(KieServicesClient kieServicesClient, JBPMConfiguration configuration, Exchange exchange) {
                ProcessServicesClient processClient = (ProcessServicesClient)kieServicesClient.getServicesClient(ProcessServicesClient.class);
                processClient.abortProcessInstance(configuration.getDeploymentId(), Long.valueOf(this.safe(this.getProcessInstanceId(configuration, exchange))));
            }
        }
        ,
        signalEvent{

            @Override
            void execute(KieServicesClient kieServicesClient, JBPMConfiguration configuration, Exchange exchange) {
                ProcessServicesClient processClient = (ProcessServicesClient)kieServicesClient.getServicesClient(ProcessServicesClient.class);
                Long processInstanceId = this.getProcessInstanceId(configuration, exchange);
                if (processInstanceId != null) {
                    processClient.signalProcessInstance(configuration.getDeploymentId(), processInstanceId, this.getEventType(configuration, exchange), this.getEvent(configuration, exchange));
                } else {
                    processClient.signal(configuration.getDeploymentId(), this.getEventType(configuration, exchange), this.getEvent(configuration, exchange));
                }
            }
        }
        ,
        getProcessInstance{

            @Override
            void execute(KieServicesClient kieServicesClient, JBPMConfiguration configuration, Exchange exchange) {
                ProcessServicesClient processClient = (ProcessServicesClient)kieServicesClient.getServicesClient(ProcessServicesClient.class);
                ProcessInstance processInstance = processClient.getProcessInstance(configuration.getDeploymentId(), Long.valueOf(this.safe(this.getProcessInstanceId(configuration, exchange))));
                this.setResult(exchange, processInstance);
            }
        }
        ,
        getProcessInstances{

            @Override
            void execute(KieServicesClient kieServicesClient, JBPMConfiguration configuration, Exchange exchange) {
                QueryServicesClient queryClient = (QueryServicesClient)kieServicesClient.getServicesClient(QueryServicesClient.class);
                List processInstances = queryClient.findProcessInstances(this.getPage(configuration, exchange), this.getPageSize(configuration, exchange));
                this.setResult(exchange, processInstances);
            }
        }
        ,
        fireAllRules{

            @Override
            void execute(KieServicesClient kieServicesClient, JBPMConfiguration configuration, Exchange exchange) {
                RuleServicesClient ruleClient = (RuleServicesClient)kieServicesClient.getServicesClient(RuleServicesClient.class);
                ArrayList<Command> commands = new ArrayList<Command>();
                BatchExecutionCommand executionCommand = commandsFactory.newBatchExecution(commands);
                Integer max = this.getMaxNumber(configuration, exchange);
                if (max != null) {
                    commands.add(commandsFactory.newFireAllRules(max.intValue()));
                } else {
                    commands.add(commandsFactory.newFireAllRules());
                }
                ServiceResponse reply = ruleClient.executeCommandsWithResults(configuration.getDeploymentId(), (Command)executionCommand);
                this.setResult(exchange, reply.getResult());
            }
        }
        ,
        getGlobal{

            @Override
            void execute(KieServicesClient kieServicesClient, JBPMConfiguration configuration, Exchange exchange) {
                RuleServicesClient ruleClient = (RuleServicesClient)kieServicesClient.getServicesClient(RuleServicesClient.class);
                ArrayList<Command> commands = new ArrayList<Command>();
                BatchExecutionCommand executionCommand = commandsFactory.newBatchExecution(commands);
                String identifier = this.getIdentifier(configuration, exchange);
                commands.add(commandsFactory.newGetGlobal(identifier, identifier));
                ServiceResponse reply = ruleClient.executeCommandsWithResults(configuration.getDeploymentId(), (Command)executionCommand);
                this.setResult(exchange, ((ExecutionResults)reply.getResult()).getValue(identifier));
            }
        }
        ,
        setGlobal{

            @Override
            void execute(KieServicesClient kieServicesClient, JBPMConfiguration configuration, Exchange exchange) {
                RuleServicesClient ruleClient = (RuleServicesClient)kieServicesClient.getServicesClient(RuleServicesClient.class);
                ArrayList<Command> commands = new ArrayList<Command>();
                BatchExecutionCommand executionCommand = commandsFactory.newBatchExecution(commands);
                commands.add(commandsFactory.newSetGlobal(this.getIdentifier(configuration, exchange), this.getValue(configuration, exchange)));
                ruleClient.executeCommandsWithResults(configuration.getDeploymentId(), (Command)executionCommand);
            }
        }
        ,
        abortWorkItem{

            @Override
            void execute(KieServicesClient kieServicesClient, JBPMConfiguration configuration, Exchange exchange) {
                ProcessServicesClient processClient = (ProcessServicesClient)kieServicesClient.getServicesClient(ProcessServicesClient.class);
                processClient.abortWorkItem(configuration.getDeploymentId(), Long.valueOf(this.safe(this.getProcessInstanceId(configuration, exchange))), Long.valueOf(this.safe(this.getWorkItemId(configuration, exchange))));
            }
        }
        ,
        completeWorkItem{

            @Override
            void execute(KieServicesClient kieServicesClient, JBPMConfiguration configuration, Exchange exchange) {
                ProcessServicesClient processClient = (ProcessServicesClient)kieServicesClient.getServicesClient(ProcessServicesClient.class);
                processClient.completeWorkItem(configuration.getDeploymentId(), Long.valueOf(this.safe(this.getProcessInstanceId(configuration, exchange))), Long.valueOf(this.safe(this.getWorkItemId(configuration, exchange))), this.getParameters(configuration, exchange));
            }
        }
        ,
        activateTask{

            @Override
            void execute(KieServicesClient kieServicesClient, JBPMConfiguration configuration, Exchange exchange) {
                UserTaskServicesClient taskClient = (UserTaskServicesClient)kieServicesClient.getServicesClient(UserTaskServicesClient.class);
                taskClient.activateTask(configuration.getDeploymentId(), Long.valueOf(this.safe(this.getTaskId(configuration, exchange))), this.getUserId(configuration, exchange));
            }
        }
        ,
        claimTask{

            @Override
            void execute(KieServicesClient kieServicesClient, JBPMConfiguration configuration, Exchange exchange) {
                UserTaskServicesClient taskClient = (UserTaskServicesClient)kieServicesClient.getServicesClient(UserTaskServicesClient.class);
                taskClient.claimTask(configuration.getDeploymentId(), Long.valueOf(this.safe(this.getTaskId(configuration, exchange))), this.getUserId(configuration, exchange));
            }
        }
        ,
        completeTask{

            @Override
            void execute(KieServicesClient kieServicesClient, JBPMConfiguration configuration, Exchange exchange) {
                UserTaskServicesClient taskClient = (UserTaskServicesClient)kieServicesClient.getServicesClient(UserTaskServicesClient.class);
                taskClient.completeAutoProgress(configuration.getDeploymentId(), Long.valueOf(this.safe(this.getTaskId(configuration, exchange))), this.getUserId(configuration, exchange), this.getParameters(configuration, exchange));
            }
        }
        ,
        delegateTask{

            @Override
            void execute(KieServicesClient kieServicesClient, JBPMConfiguration configuration, Exchange exchange) {
                UserTaskServicesClient taskClient = (UserTaskServicesClient)kieServicesClient.getServicesClient(UserTaskServicesClient.class);
                taskClient.delegateTask(configuration.getDeploymentId(), Long.valueOf(this.safe(this.getTaskId(configuration, exchange))), this.getUserId(configuration, exchange), this.getTargetUserId(configuration, exchange));
            }
        }
        ,
        exitTask{

            @Override
            void execute(KieServicesClient kieServicesClient, JBPMConfiguration configuration, Exchange exchange) {
                UserTaskServicesClient taskClient = (UserTaskServicesClient)kieServicesClient.getServicesClient(UserTaskServicesClient.class);
                taskClient.exitTask(configuration.getDeploymentId(), Long.valueOf(this.safe(this.getTaskId(configuration, exchange))), this.getUserId(configuration, exchange));
            }
        }
        ,
        failTask{

            @Override
            void execute(KieServicesClient kieServicesClient, JBPMConfiguration configuration, Exchange exchange) {
                UserTaskServicesClient taskClient = (UserTaskServicesClient)kieServicesClient.getServicesClient(UserTaskServicesClient.class);
                taskClient.failTask(configuration.getDeploymentId(), Long.valueOf(this.safe(this.getTaskId(configuration, exchange))), this.getUserId(configuration, exchange), this.getParameters(configuration, exchange));
            }
        }
        ,
        getAttachment{

            @Override
            void execute(KieServicesClient kieServicesClient, JBPMConfiguration configuration, Exchange exchange) {
                UserTaskServicesClient taskClient = (UserTaskServicesClient)kieServicesClient.getServicesClient(UserTaskServicesClient.class);
                TaskAttachment attachment = taskClient.getTaskAttachmentById(configuration.getDeploymentId(), Long.valueOf(this.safe(this.getTaskId(configuration, exchange))), Long.valueOf(this.safe(this.getAttachmentId(configuration, exchange))));
                this.setResult(exchange, attachment);
            }
        }
        ,
        getTasksAssignedAsBusinessAdministrator{

            @Override
            void execute(KieServicesClient kieServicesClient, JBPMConfiguration configuration, Exchange exchange) {
                UserTaskServicesClient taskClient = (UserTaskServicesClient)kieServicesClient.getServicesClient(UserTaskServicesClient.class);
                List taskSummaries = taskClient.findTasksAssignedAsBusinessAdministrator(this.getUserId(configuration, exchange), this.getPage(configuration, exchange), this.getPageSize(configuration, exchange));
                this.setResult(exchange, taskSummaries);
            }
        }
        ,
        getTasksAssignedAsPotentialOwnerByStatus{

            @Override
            void execute(KieServicesClient kieServicesClient, JBPMConfiguration configuration, Exchange exchange) {
                UserTaskServicesClient taskClient = (UserTaskServicesClient)kieServicesClient.getServicesClient(UserTaskServicesClient.class);
                List taskSummaries = taskClient.findTasksAssignedAsPotentialOwner(this.getUserId(configuration, exchange), this.getStatuses(configuration, exchange), this.getPage(configuration, exchange), this.getPageSize(configuration, exchange));
                this.setResult(exchange, taskSummaries);
            }
        }
        ,
        getTaskByWorkItem{

            @Override
            void execute(KieServicesClient kieServicesClient, JBPMConfiguration configuration, Exchange exchange) {
                UserTaskServicesClient taskClient = (UserTaskServicesClient)kieServicesClient.getServicesClient(UserTaskServicesClient.class);
                TaskInstance task = taskClient.findTaskByWorkItemId(Long.valueOf(this.safe(this.getWorkItemId(configuration, exchange))));
                this.setResult(exchange, task);
            }
        }
        ,
        getTaskBy{

            @Override
            void execute(KieServicesClient kieServicesClient, JBPMConfiguration configuration, Exchange exchange) {
                UserTaskServicesClient taskClient = (UserTaskServicesClient)kieServicesClient.getServicesClient(UserTaskServicesClient.class);
                TaskInstance task = taskClient.findTaskById(Long.valueOf(this.safe(this.getTaskId(configuration, exchange))));
                this.setResult(exchange, task);
            }
        }
        ,
        getTaskContent{

            @Override
            void execute(KieServicesClient kieServicesClient, JBPMConfiguration configuration, Exchange exchange) {
                UserTaskServicesClient taskClient = (UserTaskServicesClient)kieServicesClient.getServicesClient(UserTaskServicesClient.class);
                Map content = taskClient.getTaskOutputContentByTaskId(configuration.getDeploymentId(), Long.valueOf(this.safe(this.getTaskId(configuration, exchange))));
                this.setResult(exchange, content);
            }
        }
        ,
        getTasksByProcessInstance{

            @Override
            void execute(KieServicesClient kieServicesClient, JBPMConfiguration configuration, Exchange exchange) {
                UserTaskServicesClient taskClient = (UserTaskServicesClient)kieServicesClient.getServicesClient(UserTaskServicesClient.class);
                List processInstanceIds = taskClient.findTasksByStatusByProcessInstanceId(Long.valueOf(this.safe(this.getProcessInstanceId(configuration, exchange))), Collections.emptyList(), this.getPage(configuration, exchange), this.getPageSize(configuration, exchange));
                this.setResult(exchange, processInstanceIds);
            }
        }
        ,
        getTasksByStatusByProcessInstance{

            @Override
            void execute(KieServicesClient kieServicesClient, JBPMConfiguration configuration, Exchange exchange) {
                UserTaskServicesClient taskClient = (UserTaskServicesClient)kieServicesClient.getServicesClient(UserTaskServicesClient.class);
                List taskSummaryList = taskClient.findTasksByStatusByProcessInstanceId(Long.valueOf(this.safe(this.getProcessInstanceId(configuration, exchange))), this.getStatuses(configuration, exchange), this.getPage(configuration, exchange), this.getPageSize(configuration, exchange));
                this.setResult(exchange, taskSummaryList);
            }
        }
        ,
        getTasksOwned{

            @Override
            void execute(KieServicesClient kieServicesClient, JBPMConfiguration configuration, Exchange exchange) {
                UserTaskServicesClient taskClient = (UserTaskServicesClient)kieServicesClient.getServicesClient(UserTaskServicesClient.class);
                List summaryList = taskClient.findTasksOwned(this.getUserId(configuration, exchange), this.getPage(configuration, exchange), this.getPageSize(configuration, exchange));
                this.setResult(exchange, summaryList);
            }
        }
        ,
        nominateTask{

            @Override
            void execute(KieServicesClient kieServicesClient, JBPMConfiguration configuration, Exchange exchange) {
                UserTaskServicesClient taskClient = (UserTaskServicesClient)kieServicesClient.getServicesClient(UserTaskServicesClient.class);
                taskClient.nominateTask(configuration.getDeploymentId(), Long.valueOf(this.safe(this.getTaskId(configuration, exchange))), this.getUserId(configuration, exchange), this.getEntities(configuration, exchange));
            }
        }
        ,
        releaseTask{

            @Override
            void execute(KieServicesClient kieServicesClient, JBPMConfiguration configuration, Exchange exchange) {
                UserTaskServicesClient taskClient = (UserTaskServicesClient)kieServicesClient.getServicesClient(UserTaskServicesClient.class);
                taskClient.releaseTask(configuration.getDeploymentId(), Long.valueOf(this.safe(this.getTaskId(configuration, exchange))), this.getUserId(configuration, exchange));
            }
        }
        ,
        resumeTask{

            @Override
            void execute(KieServicesClient kieServicesClient, JBPMConfiguration configuration, Exchange exchange) {
                UserTaskServicesClient taskClient = (UserTaskServicesClient)kieServicesClient.getServicesClient(UserTaskServicesClient.class);
                taskClient.resumeTask(configuration.getDeploymentId(), Long.valueOf(this.safe(this.getTaskId(configuration, exchange))), this.getUserId(configuration, exchange));
            }
        }
        ,
        skipTask{

            @Override
            void execute(KieServicesClient kieServicesClient, JBPMConfiguration configuration, Exchange exchange) {
                UserTaskServicesClient taskClient = (UserTaskServicesClient)kieServicesClient.getServicesClient(UserTaskServicesClient.class);
                taskClient.skipTask(configuration.getDeploymentId(), Long.valueOf(this.safe(this.getTaskId(configuration, exchange))), this.getUserId(configuration, exchange));
            }
        }
        ,
        startTask{

            @Override
            void execute(KieServicesClient kieServicesClient, JBPMConfiguration configuration, Exchange exchange) {
                UserTaskServicesClient taskClient = (UserTaskServicesClient)kieServicesClient.getServicesClient(UserTaskServicesClient.class);
                taskClient.startTask(configuration.getDeploymentId(), Long.valueOf(this.safe(this.getTaskId(configuration, exchange))), this.getUserId(configuration, exchange));
            }
        }
        ,
        stopTask{

            @Override
            void execute(KieServicesClient kieServicesClient, JBPMConfiguration configuration, Exchange exchange) {
                UserTaskServicesClient taskClient = (UserTaskServicesClient)kieServicesClient.getServicesClient(UserTaskServicesClient.class);
                taskClient.stopTask(configuration.getDeploymentId(), Long.valueOf(this.safe(this.getTaskId(configuration, exchange))), this.getUserId(configuration, exchange));
            }
        }
        ,
        suspendTask{

            @Override
            void execute(KieServicesClient kieServicesClient, JBPMConfiguration configuration, Exchange exchange) {
                UserTaskServicesClient taskClient = (UserTaskServicesClient)kieServicesClient.getServicesClient(UserTaskServicesClient.class);
                taskClient.suspendTask(configuration.getDeploymentId(), Long.valueOf(this.safe(this.getTaskId(configuration, exchange))), this.getUserId(configuration, exchange));
            }
        };


        List<String> getStatuses(JBPMConfiguration configuration, Exchange exchange) {
            List<String> statusList = (List<String>)exchange.getIn().getHeader("CamelJBPMStatusList", List.class);
            if (statusList == null) {
                statusList = configuration.getStatuses();
            }
            return statusList;
        }

        List<String> getEntities(JBPMConfiguration configuration, Exchange exchange) {
            List<String> entityList = (List<String>)exchange.getIn().getHeader("CamelJBPMEntityList", List.class);
            if (entityList == null) {
                entityList = configuration.getEntities();
            }
            return entityList;
        }

        Long getAttachmentId(JBPMConfiguration configuration, Exchange exchange) {
            Long attachmentId = (Long)exchange.getIn().getHeader("CamelJBPMAttachmentId", Long.class);
            if (attachmentId == null) {
                attachmentId = configuration.getAttachmentId();
            }
            return attachmentId;
        }

        Long getContentId(JBPMConfiguration configuration, Exchange exchange) {
            Long contentId = (Long)exchange.getIn().getHeader("CamelJBPMContentId", Long.class);
            if (contentId == null) {
                contentId = configuration.getContentId();
            }
            return contentId;
        }

        String getTargetUserId(JBPMConfiguration configuration, Exchange exchange) {
            String userId = (String)exchange.getIn().getHeader("CamelJBPMTargetUserId", String.class);
            if (userId == null) {
                userId = configuration.getTargetUserId();
            }
            return userId;
        }

        Integer getPage(JBPMConfiguration configuration, Exchange exchange) {
            Integer page = (Integer)exchange.getIn().getHeader("CamelJBPMResultPage", Integer.class);
            if (page == null) {
                page = configuration.getPage();
            }
            return page;
        }

        Integer getPageSize(JBPMConfiguration configuration, Exchange exchange) {
            Integer pageSize = (Integer)exchange.getIn().getHeader("CamelJBPMResultPageSize", Integer.class);
            if (pageSize == null) {
                pageSize = configuration.getPageSize();
            }
            return pageSize;
        }

        Task getTask(JBPMConfiguration configuration, Exchange exchange) {
            Task task = (Task)exchange.getIn().getHeader("CamelJBPMTask", Task.class);
            if (task == null) {
                task = configuration.getTask();
            }
            return task;
        }

        String getUserId(JBPMConfiguration configuration, Exchange exchange) {
            String userId = (String)exchange.getIn().getHeader("CamelJBPMUserId", String.class);
            if (userId == null) {
                userId = configuration.getUserId();
            }
            return userId;
        }

        Long getTaskId(JBPMConfiguration configuration, Exchange exchange) {
            Long taskId = (Long)exchange.getIn().getHeader("CamelJBPMTaskId", Long.class);
            if (taskId == null) {
                taskId = configuration.getTaskId();
            }
            return taskId;
        }

        Long getWorkItemId(JBPMConfiguration configuration, Exchange exchange) {
            Long workItemId = (Long)exchange.getIn().getHeader("CamelJBPMWorkItemId", Long.class);
            if (workItemId == null) {
                workItemId = configuration.getWorkItemId();
            }
            return workItemId;
        }

        String getIdentifier(JBPMConfiguration configuration, Exchange exchange) {
            String identifier = (String)exchange.getIn().getHeader("CamelJBPMIdentifier", String.class);
            if (identifier == null) {
                identifier = configuration.getIdentifier();
            }
            return identifier;
        }

        Integer getMaxNumber(JBPMConfiguration configuration, Exchange exchange) {
            Integer max = (Integer)exchange.getIn().getHeader("CamelJBPMMaxNumber", Integer.class);
            if (max == null) {
                max = configuration.getMaxNumber();
            }
            return max;
        }

        Object getEvent(JBPMConfiguration configuration, Exchange exchange) {
            Object event = exchange.getIn().getHeader("CamelJBPMEvent");
            if (event == null) {
                event = configuration.getEvent();
            }
            return event;
        }

        String getEventType(JBPMConfiguration configuration, Exchange exchange) {
            String eventType = (String)exchange.getIn().getHeader("CamelJBPMEventType", String.class);
            if (eventType == null) {
                eventType = configuration.getEventType();
            }
            return eventType;
        }

        String getProcessId(JBPMConfiguration configuration, Exchange exchange) {
            String processId = (String)exchange.getIn().getHeader("CamelJBPMProcessId", String.class);
            if (processId == null) {
                processId = configuration.getProcessId();
            }
            return processId;
        }

        Long getProcessInstanceId(JBPMConfiguration configuration, Exchange exchange) {
            Long processInstanceId = (Long)exchange.getIn().getHeader("CamelJBPMProcessInstanceId", Long.class);
            if (processInstanceId == null) {
                processInstanceId = configuration.getProcessInstanceId();
            }
            return processInstanceId;
        }

        Map<String, Object> getParameters(JBPMConfiguration configuration, Exchange exchange) {
            Map<String, Object> parameters = (Map<String, Object>)exchange.getIn().getHeader("CamelJBPMParameters", Map.class);
            if (parameters == null) {
                parameters = configuration.getParameters();
            }
            return parameters;
        }

        Object getValue(JBPMConfiguration configuration, Exchange exchange) {
            Object value = exchange.getIn().getHeader("CamelJBPMValue");
            if (value == null) {
                value = configuration.getValue();
            }
            return value;
        }

        Message getResultMessage(Exchange exchange) {
            return ExchangeHelper.isOutCapable((Exchange)exchange) ? exchange.getOut() : exchange.getIn();
        }

        long safe(Long aLong) {
            return aLong != null ? aLong : 0L;
        }

        void setResult(Exchange exchange, Object result) {
            this.getResultMessage(exchange).setBody(result);
        }

        abstract void execute(KieServicesClient var1, JBPMConfiguration var2, Exchange var3);
    }
}

