/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jbpm;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.component.jbpm.JBPMCamelConsumerAware;
import org.apache.camel.component.jbpm.JBPMConfiguration;
import org.apache.camel.component.jbpm.JBPMEndpoint;
import org.apache.camel.component.jbpm.emitters.CamelEventEmitter;
import org.apache.camel.component.jbpm.listeners.CamelCaseEventListener;
import org.apache.camel.component.jbpm.listeners.CamelProcessEventListener;
import org.apache.camel.component.jbpm.listeners.CamelTaskEventListener;
import org.apache.camel.impl.DefaultConsumer;
import org.jbpm.services.api.DeploymentEvent;
import org.jbpm.services.api.DeploymentEventListener;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.ListenerSupport;
import org.jbpm.services.api.model.DeployedUnit;
import org.jbpm.services.api.service.ServiceRegistry;
import org.kie.internal.runtime.manager.CacheManager;
import org.kie.internal.runtime.manager.InternalRuntimeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JBPMConsumer
extends DefaultConsumer
implements DeploymentEventListener {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(JBPMConsumer.class);
    private JBPMEndpoint endpoint;
    private JBPMConfiguration configuration;

    public JBPMConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = (JBPMEndpoint)endpoint;
        this.configuration = ((JBPMEndpoint)this.getEndpoint()).getConfiguration();
    }

    protected void doStart() throws Exception {
        super.doStart();
        DeploymentService deploymentService = (DeploymentService)ServiceRegistry.get().service(ServiceRegistry.DEPLOYMENT_SERVICE);
        if (this.configuration.getDeploymentId() != null) {
            InternalRuntimeManager manager = (InternalRuntimeManager)deploymentService.getRuntimeManager(this.configuration.getDeploymentId());
            this.configure(manager, this);
            LOGGER.debug("JBPM Camel Consumer configured and started for deployment id {}", (Object)this.configuration.getDeploymentId());
        } else {
            ((ListenerSupport)deploymentService).addListener((DeploymentEventListener)this);
            for (DeployedUnit deployed : deploymentService.getDeployedUnits()) {
                InternalRuntimeManager manager = (InternalRuntimeManager)deployed.getRuntimeManager();
                this.configure(manager, this);
            }
            LOGGER.debug("JBPM Camel Consumer configured and started on all available deployments");
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        DeploymentService deploymentService = (DeploymentService)ServiceRegistry.get().service(ServiceRegistry.DEPLOYMENT_SERVICE);
        if (this.configuration.getDeploymentId() != null) {
            LOGGER.debug("JBPM Camel Consumer unconfigured and stopped for deployment id {}", (Object)this.configuration.getDeploymentId());
        } else {
            ((ListenerSupport)deploymentService).removeListener((DeploymentEventListener)this);
            LOGGER.debug("JBPM Camel Consumer unconfigured and stopped on all available deployments");
        }
        if ("emitter".equals(this.configuration.getEventListenerType())) {
            ServiceRegistry.get().remove("CamelEventEmitter");
        }
    }

    public void sendMessage(String eventType, Object body) {
        final Exchange exchange = this.getEndpoint().createExchange(ExchangePattern.InOnly);
        exchange.getIn().setHeader("EventType", (Object)eventType);
        exchange.getIn().setBody(body);
        if (!this.endpoint.isSynchronous()) {
            this.getAsyncProcessor().process(exchange, new AsyncCallback(){

                public void done(boolean doneSync) {
                    if (exchange.getException() != null) {
                        JBPMConsumer.this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
                    }
                }
            });
        } else {
            try {
                this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
            }
            if (exchange.getException() != null) {
                this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)exchange.getException());
            }
        }
    }

    public void onDeploy(DeploymentEvent event) {
        InternalRuntimeManager manager = (InternalRuntimeManager)event.getDeployedUnit().getRuntimeManager();
        this.configure(manager, this);
    }

    public void onUnDeploy(DeploymentEvent event) {
    }

    public void onActivate(DeploymentEvent event) {
    }

    public void onDeactivate(DeploymentEvent event) {
    }

    protected void configure(InternalRuntimeManager manager, JBPMConsumer consumer) {
        String eventListenerType = this.configuration.getEventListenerType();
        if (eventListenerType == null) {
            return;
        }
        this.configureConsumer(eventListenerType, manager, consumer);
    }

    protected void configureConsumer(String eventListenerType, InternalRuntimeManager manager, JBPMConsumer consumer) {
        LOGGER.debug("Configuring Camel JBPM Consumer for {} on runtime manager {}", (Object)eventListenerType, (Object)manager);
        CacheManager cacheManager = manager.getCacheManager();
        JBPMCamelConsumerAware consumerAware = null;
        if ("process".equals(eventListenerType)) {
            consumerAware = (JBPMCamelConsumerAware)cacheManager.get("new org.apache.camel.component.jbpm.listeners.CamelProcessEventListener()");
            if (consumerAware == null) {
                consumerAware = new CamelProcessEventListener();
                cacheManager.add("new org.apache.camel.component.jbpm.listeners.CamelProcessEventListener()", (Object)consumerAware);
            }
            LOGGER.debug("Configuring JBPMConsumer on process event listener {}", (Object)consumerAware);
        } else if ("task".equals(eventListenerType)) {
            consumerAware = (JBPMCamelConsumerAware)cacheManager.get("new org.apache.camel.component.jbpm.listeners.CamelTaskEventListener()");
            if (consumerAware == null) {
                consumerAware = new CamelTaskEventListener();
                cacheManager.add("new org.apache.camel.component.jbpm.listeners.CamelTaskEventListener()", (Object)consumerAware);
            }
            LOGGER.debug("Configuring JBPMConsumer on task event listener {}", (Object)consumerAware);
        } else if ("case".equals(eventListenerType)) {
            consumerAware = (JBPMCamelConsumerAware)cacheManager.get("new org.apache.camel.component.jbpm.listeners.CamelCaseEventListener()");
            if (consumerAware == null) {
                consumerAware = new CamelCaseEventListener();
                cacheManager.add("new org.apache.camel.component.jbpm.listeners.CamelCaseEventListener()", (Object)consumerAware);
            }
            LOGGER.debug("Configuring JBPMConsumer on case event listener {}", (Object)consumerAware);
        } else if ("emitter".equals(eventListenerType)) {
            LOGGER.debug("Configuring JBPMConsumer for event emitter");
            ServiceRegistry.get().register("CamelEventEmitter", (Object)new CamelEventEmitter(this, this.configuration.getEmitterSendItems()));
            return;
        }
        LOGGER.debug("Adding consumer {} on {}", (Object)consumer, (Object)consumerAware);
        consumerAware.addConsumer(consumer);
    }

    public String toString() {
        return "JBPMConsumer [endpoint=" + (Object)((Object)this.endpoint) + ", configuration=" + this.configuration + "]";
    }
}

