/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.thrift;

import java.net.URI;
import java.util.Map;
import org.apache.camel.component.thrift.ThriftComponent;
import org.apache.camel.component.thrift.ThriftCompressionType;
import org.apache.camel.component.thrift.ThriftExchangeProtocol;
import org.apache.camel.component.thrift.ThriftNegotiationType;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.jsse.SSLContextParameters;

@UriParams
public class ThriftConfiguration {
    @UriPath
    private String host;
    @UriPath
    @Metadata(required="true")
    private int port;
    @UriPath
    @Metadata(required="true")
    private String service;
    @UriParam(label="producer")
    private String method;
    @UriParam(defaultValue="BINARY")
    private ThriftExchangeProtocol exchangeProtocol = ThriftExchangeProtocol.BINARY;
    @UriParam(label="security", defaultValue="PLAINTEXT")
    private ThriftNegotiationType negotiationType = ThriftNegotiationType.PLAINTEXT;
    @UriParam(label="security")
    private SSLContextParameters sslParameters;
    @UriParam(defaultValue="NONE")
    private ThriftCompressionType compressionType = ThriftCompressionType.NONE;
    @UriParam(label="consumer")
    private int clientTimeout;
    @UriParam(label="consumer", defaultValue="1")
    private int poolSize = 1;
    @UriParam(label="consumer", defaultValue="10")
    private int maxPoolSize = 10;

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public ThriftExchangeProtocol getExchangeProtocol() {
        return this.exchangeProtocol;
    }

    public void setExchangeProtocol(ThriftExchangeProtocol exchangeProtocol) {
        this.exchangeProtocol = exchangeProtocol;
    }

    public ThriftNegotiationType getNegotiationType() {
        return this.negotiationType;
    }

    public void setNegotiationType(ThriftNegotiationType negotiationType) {
        this.negotiationType = negotiationType;
    }

    public SSLContextParameters getSslParameters() {
        return this.sslParameters;
    }

    public void setSslParameters(SSLContextParameters sslParameters) {
        this.sslParameters = sslParameters;
    }

    public ThriftCompressionType getCompressionType() {
        return this.compressionType;
    }

    public void setCompressionType(ThriftCompressionType compressionType) {
        this.compressionType = compressionType;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getClientTimeout() {
        return this.clientTimeout;
    }

    public void setClientTimeout(int clientTimeout) {
        this.clientTimeout = clientTimeout;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public void parseURI(URI uri, Map<String, Object> parameters, ThriftComponent component) {
        this.setHost(uri.getHost());
        if (uri.getPort() != -1) {
            this.setPort(uri.getPort());
        }
        this.setService(uri.getPath().substring(1));
    }
}

