/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.validator.jing;

import com.thaiopensource.relaxng.SchemaFactory;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.xml.sax.Jaxp11XMLReaderCreator;
import com.thaiopensource.xml.sax.XMLReaderCreator;
import java.io.InputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.validator.jing.JingValidator;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ResourceHelper;
import org.apache.camel.util.StringHelper;
import org.xml.sax.InputSource;

@UriEndpoint(firstVersion="1.1.0", scheme="jing", title="Jing", syntax="jing:resourceUri", producerOnly=true, label="validation")
public class JingEndpoint
extends DefaultEndpoint {
    @UriPath
    @Metadata(required="true")
    private String resourceUri;
    @UriParam
    private boolean compactSyntax;
    private Schema schema;
    private SchemaFactory schemaFactory;
    private InputSource inputSource;

    public JingEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    public Producer createProducer() throws Exception {
        JingValidator answer = new JingValidator((Endpoint)this);
        answer.setSchema(this.getSchema());
        return answer;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("This endpoint does not support consumer");
    }

    public boolean isSingleton() {
        return true;
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public void setResourceUri(String resourceUri) {
        this.resourceUri = resourceUri;
    }

    public boolean isCompactSyntax() {
        return this.compactSyntax;
    }

    public void setCompactSyntax(boolean compactSyntax) {
        this.compactSyntax = compactSyntax;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public SchemaFactory getSchemaFactory() {
        return this.schemaFactory;
    }

    public void setSchemaFactory(SchemaFactory schemaFactory) {
        this.schemaFactory = schemaFactory;
    }

    public InputSource getInputSource() {
        return this.inputSource;
    }

    public void setInputSource(InputSource inputSource) {
        this.inputSource = inputSource;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.inputSource == null) {
            StringHelper.notEmpty((String)this.resourceUri, (String)"resourceUri", (Object)((Object)this));
            InputStream inputStream = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)this.getCamelContext(), (String)this.resourceUri);
            this.inputSource = new InputSource(inputStream);
        }
        if (this.schemaFactory == null) {
            this.schemaFactory = new SchemaFactory();
            this.schemaFactory.setCompactSyntax(this.compactSyntax);
            this.schemaFactory.setXMLReaderCreator((XMLReaderCreator)new Jaxp11XMLReaderCreator());
        }
        if (this.schema == null) {
            this.schema = this.schemaFactory.createSchema(this.inputSource);
        }
    }
}

