/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.redis;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Processor;
import org.apache.camel.component.redis.Command;
import org.apache.camel.component.redis.ConnectionRedisProcessorsCreator;
import org.apache.camel.component.redis.ExchangeConverter;
import org.apache.camel.component.redis.GeoRedisProcessorsCreator;
import org.apache.camel.component.redis.HashesRedisProcessorsCreator;
import org.apache.camel.component.redis.KeysRedisProcessorsCreator;
import org.apache.camel.component.redis.ListsRedisProcessorsCreator;
import org.apache.camel.component.redis.PubSubRedisProcessorsCreator;
import org.apache.camel.component.redis.RedisClient;
import org.apache.camel.component.redis.RedisProcessorsCreator;
import org.apache.camel.component.redis.SetsRedisProcessorsCreator;
import org.apache.camel.component.redis.SortedSetsRedisProcessorsCreator;
import org.apache.camel.component.redis.StringsRedisProcessorsCreator;
import org.apache.camel.component.redis.TransactionRedisProcessorsCreator;

public class AllRedisProcessorsCreator
implements RedisProcessorsCreator {
    private final Map<Command, Processor> processors = new HashMap<Command, Processor>();

    public AllRedisProcessorsCreator(RedisClient redisClient, ExchangeConverter exchangeConverter) {
        this.processors.putAll(new ConnectionRedisProcessorsCreator().getProcessors(redisClient, exchangeConverter));
        this.processors.putAll(new HashesRedisProcessorsCreator().getProcessors(redisClient, exchangeConverter));
        this.processors.putAll(new KeysRedisProcessorsCreator().getProcessors(redisClient, exchangeConverter));
        this.processors.putAll(new ListsRedisProcessorsCreator().getProcessors(redisClient, exchangeConverter));
        this.processors.putAll(new PubSubRedisProcessorsCreator().getProcessors(redisClient, exchangeConverter));
        this.processors.putAll(new SetsRedisProcessorsCreator().getProcessors(redisClient, exchangeConverter));
        this.processors.putAll(new SortedSetsRedisProcessorsCreator().getProcessors(redisClient, exchangeConverter));
        this.processors.putAll(new StringsRedisProcessorsCreator().getProcessors(redisClient, exchangeConverter));
        this.processors.putAll(new TransactionRedisProcessorsCreator().getProcessors(redisClient, exchangeConverter));
        this.processors.putAll(new GeoRedisProcessorsCreator().getProcessors(redisClient, exchangeConverter));
    }

    @Override
    public Map<Command, Processor> getRedisProcessors() {
        return this.processors;
    }
}

