/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.client;

import java.util.Objects;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.milo.Messages;
import org.apache.camel.component.milo.client.MiloClientConnection;
import org.apache.camel.component.milo.client.MiloClientEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.impl.DefaultMessage;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiloClientConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(MiloClientConsumer.class);
    private final MiloClientConnection connection;
    private MiloClientConnection.MonitorHandle handle;
    private ExpandedNodeId node;
    private Double samplingInterval;

    public MiloClientConsumer(MiloClientEndpoint endpoint, Processor processor, MiloClientConnection connection) {
        super((Endpoint)endpoint, processor);
        Objects.requireNonNull(connection);
        this.connection = connection;
        this.node = endpoint.getNodeId();
        this.samplingInterval = endpoint.getSamplingInterval();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.handle = this.connection.monitorValue(this.node, this.samplingInterval, this::handleValueUpdate);
    }

    protected void doStop() throws Exception {
        if (this.handle != null) {
            this.handle.unregister();
            this.handle = null;
        }
        super.doStop();
    }

    private void handleValueUpdate(DataValue value) {
        LOG.debug("Handle item update - {} = {}", (Object)this.node, (Object)value);
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.setIn(this.mapMessage(value));
        try {
            this.getAsyncProcessor().process(exchange);
        }
        catch (Exception e) {
            LOG.debug("Failed to process message", (Throwable)e);
        }
    }

    private Message mapMessage(DataValue value) {
        if (value == null) {
            return null;
        }
        DefaultMessage result = new DefaultMessage(this.getEndpoint().getCamelContext());
        Messages.fillFromDataValue(value, result);
        return result;
    }
}

