/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.client;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.camel.component.milo.client.MiloClientConfiguration;
import org.apache.camel.component.milo.client.internal.SubscriptionManager;
import org.eclipse.milo.opcua.stack.core.Stack;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodResult;

public class MiloClientConnection
implements AutoCloseable {
    private final MiloClientConfiguration configuration;
    private SubscriptionManager manager;
    private boolean initialized;

    public MiloClientConnection(MiloClientConfiguration configuration) {
        Objects.requireNonNull(configuration);
        this.configuration = configuration.clone();
    }

    protected void init() throws Exception {
        this.manager = new SubscriptionManager(this.configuration, Stack.sharedScheduledExecutor(), 10000L);
    }

    @Override
    public void close() throws Exception {
        if (this.manager != null) {
            this.manager.dispose();
            this.manager = null;
        }
    }

    protected synchronized void checkInit() {
        if (this.initialized) {
            return;
        }
        try {
            this.init();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.initialized = true;
    }

    public MonitorHandle monitorValue(ExpandedNodeId nodeId, Double samplingInterval, Consumer<DataValue> valueConsumer) {
        Objects.requireNonNull(this.configuration);
        Objects.requireNonNull(valueConsumer);
        this.checkInit();
        UInteger handle = this.manager.registerItem(nodeId, samplingInterval, valueConsumer);
        return () -> this.manager.unregisterItem(handle);
    }

    public String getConnectionId() {
        return this.configuration.toCacheId();
    }

    public CompletableFuture<?> writeValue(ExpandedNodeId nodeId, Object value) {
        this.checkInit();
        return this.manager.write(nodeId, this.mapWriteValue(value));
    }

    public CompletableFuture<CallMethodResult> call(ExpandedNodeId nodeId, ExpandedNodeId methodId, Object value) {
        this.checkInit();
        return this.manager.call(nodeId, methodId, this.mapCallValue(value));
    }

    private Variant[] mapCallValue(Object value) {
        if (value == null) {
            return new Variant[0];
        }
        if (value instanceof Variant[]) {
            return (Variant[])value;
        }
        if (value instanceof Variant) {
            return new Variant[]{(Variant)value};
        }
        return new Variant[]{new Variant(value)};
    }

    private DataValue mapWriteValue(Object value) {
        if (value instanceof DataValue) {
            return (DataValue)value;
        }
        if (value instanceof Variant) {
            return new DataValue((Variant)value, StatusCode.GOOD, null, null);
        }
        return new DataValue(new Variant(value), StatusCode.GOOD, null, null);
    }

    @FunctionalInterface
    public static interface MonitorHandle {
        public void unregister();
    }
}

