/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog.nexus;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import java.util.Set;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.maven.ComponentArtifactHelper;
import org.apache.camel.catalog.nexus.BaseNexusRepository;
import org.apache.camel.catalog.nexus.NexusArtifactDto;

public class ComponentCatalogNexusRepository
extends BaseNexusRepository {
    private CamelCatalog camelCatalog;

    public ComponentCatalogNexusRepository() {
        super("component");
    }

    public CamelCatalog getCamelCatalog() {
        return this.camelCatalog;
    }

    public void setCamelCatalog(CamelCatalog camelCatalog) {
        this.camelCatalog = camelCatalog;
    }

    @Override
    public void start() {
        if (this.camelCatalog == null) {
            throw new IllegalArgumentException("CamelCatalog must be configured");
        }
        super.start();
    }

    @Override
    public void onNewArtifacts(Set<NexusArtifactDto> newArtifacts) {
        for (NexusArtifactDto dto : newArtifacts) {
            try {
                this.logger.debug("Processing new artifact: {}:{}:{}", new Object[]{dto.getGroupId(), dto.getArtifactId(), dto.getVersion()});
                String url = this.createArtifactURL(dto);
                URL jarUrl = new URL(url);
                this.addCustomCamelComponentsFromArtifact(dto, jarUrl);
            }
            catch (Throwable e) {
                this.logger.warn("Error downloading component JAR " + dto.getArtifactLink() + ". This exception is ignored. " + e.getMessage());
            }
        }
    }

    protected void addComponent(NexusArtifactDto dto, CamelCatalog camelCatalog, String scheme, String javaType, String json) {
        camelCatalog.addComponent(scheme, javaType, json);
        this.logger.info("Added component: {}:{}:{} to Camel Catalog", new Object[]{dto.getGroupId(), dto.getArtifactId(), dto.getVersion()});
    }

    private void addCustomCamelComponentsFromArtifact(NexusArtifactDto dto, URL jarUrl) {
        try (URLClassLoader classLoader = new URLClassLoader(new URL[]{jarUrl});){
            Properties properties = ComponentArtifactHelper.loadComponentProperties((boolean)this.log, (ClassLoader)classLoader);
            String components = (String)properties.get("components");
            if (components != null) {
                String[] part;
                for (String scheme : part = components.split("\\s")) {
                    String json;
                    String javaType;
                    if (this.getCamelCatalog().findComponentNames().contains(scheme) || (javaType = ComponentArtifactHelper.extractComponentJavaType((boolean)this.log, (ClassLoader)classLoader, (String)scheme)) == null || (json = ComponentArtifactHelper.loadComponentJSonSchema((boolean)this.log, (ClassLoader)classLoader, (String)scheme)) == null) continue;
                    this.addComponent(dto, this.getCamelCatalog(), scheme, javaType, json);
                }
            }
        }
        catch (IOException e) {
            this.logger.warn("Error scanning JAR for custom Camel components", (Throwable)e);
        }
    }
}

