/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog.nexus;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.camel.catalog.nexus.NexusArtifactDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class BaseNexusRepository {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    boolean log;
    private final Set<NexusArtifactDto> indexedArtifacts = new LinkedHashSet<NexusArtifactDto>();
    private volatile ScheduledExecutorService executorService;
    private AtomicBoolean started = new AtomicBoolean();
    private int initialDelay = 10;
    private int delay = 60;
    private String nexusUrl = "http://nexus/service/local/data_index";
    private String classifier;

    public BaseNexusRepository(String classifier) {
        this.classifier = classifier;
    }

    public void setLog(boolean log) {
        this.log = log;
    }

    public String getNexusUrl() {
        return this.nexusUrl;
    }

    public void setNexusUrl(String nexusUrl) {
        this.nexusUrl = nexusUrl;
    }

    public int getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(int initialDelay) {
        this.initialDelay = initialDelay;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public void start() {
        if (this.nexusUrl == null || this.nexusUrl.isEmpty()) {
            this.logger.warn("Nexus service not found. Indexing Nexus is not enabled!");
            return;
        }
        if (!this.started.compareAndSet(false, true)) {
            this.logger.info("NexusRepository is already started");
            return;
        }
        this.logger.info("Starting NexusRepository to scan every {} seconds", (Object)this.delay);
        this.executorService = Executors.newScheduledThreadPool(1);
        this.executorService.scheduleWithFixedDelay(() -> {
            try {
                this.logger.debug("Indexing Nexus {} +++ start +++", (Object)this.nexusUrl);
                this.indexNexus();
            }
            catch (Throwable e) {
                if (e.getMessage().contains("UnknownHostException")) {
                    this.logger.warn("Error indexing Nexus " + this.nexusUrl + " due unknown hosts: " + e.getMessage());
                } else {
                    this.logger.warn("Error indexing Nexus " + this.nexusUrl + " due " + e.getMessage(), e);
                }
            }
            finally {
                this.logger.debug("Indexing Nexus {} +++ end +++", (Object)this.nexusUrl);
            }
        }, this.initialDelay, this.delay, TimeUnit.SECONDS);
    }

    public void stop() {
        this.logger.info("Stopping NexusRepository");
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
        this.indexedArtifacts.clear();
        this.started.set(false);
    }

    abstract void onNewArtifacts(Set<NexusArtifactDto> var1);

    protected URL createNexusUrl() throws MalformedURLException {
        String query = this.nexusUrl + "?q=" + this.getClassifier();
        return new URL(query);
    }

    protected String createArtifactURL(NexusArtifactDto dto) {
        return dto.getArtifactLink();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void indexNexus() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setIgnoringComments(true);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        URL url = this.createNexusUrl();
        InputStream is = url.openStream();
        try {
            Document dom = documentBuilder.parse(is);
            XPathFactory xpFactory = XPathFactory.newInstance();
            XPath exp = xpFactory.newXPath();
            NodeList list = (NodeList)exp.evaluate("//data/artifact", dom, XPathConstants.NODESET);
            LinkedHashSet<NexusArtifactDto> newArtifacts = new LinkedHashSet<NexusArtifactDto>();
            for (int i = 0; i < list.getLength(); ++i) {
                String l;
                String v;
                String a;
                Node node = list.item(i);
                String g = BaseNexusRepository.getNodeText(node.getChildNodes(), "groupId");
                if (!(g != null & (a = BaseNexusRepository.getNodeText(node.getChildNodes(), "artifactId")) != null & (v = BaseNexusRepository.getNodeText(node.getChildNodes(), "version")) != null & (l = BaseNexusRepository.getNodeText(node.getChildNodes(), "artifactLink")) != null)) continue;
                NexusArtifactDto dto = new NexusArtifactDto();
                dto.setGroupId(g);
                dto.setArtifactId(a);
                dto.setVersion(v);
                dto.setArtifactLink(l);
                this.logger.debug("Found: {}:{}:{}", new Object[]{dto.getGroupId(), dto.getArtifactId(), dto.getVersion()});
                boolean newArtifact = true;
                for (NexusArtifactDto existing : this.indexedArtifacts) {
                    if (!existing.getGroupId().equals(dto.getGroupId()) || !existing.getArtifactId().equals(dto.getArtifactId()) || !existing.getVersion().equals(dto.getVersion())) continue;
                    newArtifact = false;
                    break;
                }
                if (!newArtifact) continue;
                newArtifacts.add(dto);
            }
            if (!newArtifacts.isEmpty()) {
                this.onNewArtifacts(newArtifacts);
            }
        }
        catch (Throwable throwable) {
            BaseNexusRepository.close(is);
            throw throwable;
        }
        BaseNexusRepository.close(is);
    }

    private static String getNodeText(NodeList list, String name) {
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            if (!name.equals(child.getNodeName())) continue;
            return child.getTextContent();
        }
        return null;
    }

    private static void close(Closeable ... closeables) {
        for (Closeable c : closeables) {
            try {
                if (c == null) continue;
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

