/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import org.apache.camel.component.smpp.SmppSplitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmppNLSTSplitter
extends SmppSplitter {
    protected static final int UDHIE_NLI_SINGLE_MSG_HEADER_LENGTH = 3;
    protected static final int UDHIE_NLI_SINGLE_MSG_HEADER_REAL_LENGTH = 4;
    protected static final int UDHIE_NLI_MULTI_MSG_HEADER_LENGTH = 8;
    protected static final int UDHIE_NLI_MULTI_MSG_HEADER_REAL_LENGTH = 9;
    protected static final int UDHIE_NLI_IDENTIFIER = 37;
    protected static final int UDHIE_NLI_HEADER_LENGTH = 1;
    public static final int MAX_MSG_CHAR_SIZE = 155;
    public static final int MAX_SEG_BYTE_SIZE = 149;
    private byte languageIdentifier;
    private final Logger logger = LoggerFactory.getLogger(SmppNLSTSplitter.class);

    public SmppNLSTSplitter(int currentLength, byte languageIdentifier) {
        super(155, 149, currentLength);
        this.languageIdentifier = languageIdentifier;
    }

    @Override
    public byte[][] split(byte[] message) {
        if (!this.isSplitRequired()) {
            byte[] nliMessage = new byte[4 + message.length];
            nliMessage[0] = 3;
            nliMessage[1] = 37;
            nliMessage[2] = 1;
            nliMessage[3] = this.languageIdentifier;
            System.arraycopy(message, 0, nliMessage, 4, message.length);
            return new byte[][]{nliMessage};
        }
        int segmentLength = this.getSegmentLength();
        int segmentNum = message.length / segmentLength;
        int messageLength = message.length;
        if (segmentNum > 255) {
            segmentNum = 255;
            messageLength = segmentNum * segmentLength;
        }
        if (messageLength % segmentLength > 0) {
            ++segmentNum;
        }
        byte[][] segments = new byte[segmentNum][];
        byte refNum = SmppNLSTSplitter.getReferenceNumber();
        for (int i = 0; i < segmentNum; ++i) {
            this.logger.debug("segment number = {}", (Object)i);
            int lengthOfData = segmentNum - i == 1 ? messageLength - i * segmentLength : segmentLength;
            this.logger.debug("Length of data = {}", (Object)lengthOfData);
            segments[i] = new byte[9 + lengthOfData];
            this.logger.debug("segments[{}].length = {}", (Object)i, (Object)segments[i].length);
            segments[i][0] = 8;
            segments[i][1] = 0;
            segments[i][2] = 3;
            segments[i][3] = refNum;
            segments[i][4] = (byte)segmentNum;
            segments[i][5] = (byte)(i + 1);
            segments[i][6] = 37;
            segments[i][7] = 1;
            segments[i][8] = this.languageIdentifier;
            System.arraycopy(message, i * segmentLength, segments[i], 9, lengthOfData);
        }
        return segments;
    }
}

