/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer.messagehistory;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.MessageHistory;
import org.apache.camel.NamedNode;
import org.apache.camel.NonManagedService;
import org.apache.camel.StaticService;
import org.apache.camel.component.micrometer.MicrometerUtils;
import org.apache.camel.component.micrometer.messagehistory.MicrometerMessageHistory;
import org.apache.camel.component.micrometer.messagehistory.MicrometerMessageHistoryNamingStrategy;
import org.apache.camel.component.micrometer.messagehistory.MicrometerMessageHistoryService;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ObjectHelper;

public class MicrometerMessageHistoryFactory
extends ServiceSupport
implements CamelContextAware,
StaticService,
NonManagedService,
MessageHistoryFactory {
    private CamelContext camelContext;
    private MeterRegistry meterRegistry;
    private boolean prettyPrint = true;
    private TimeUnit durationUnit = TimeUnit.MILLISECONDS;
    private MicrometerMessageHistoryNamingStrategy namingStrategy = MicrometerMessageHistoryNamingStrategy.DEFAULT;

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    public void setMeterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public TimeUnit getDurationUnit() {
        return this.durationUnit;
    }

    public void setDurationUnit(TimeUnit durationUnit) {
        this.durationUnit = durationUnit;
    }

    public MicrometerMessageHistoryNamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(MicrometerMessageHistoryNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    @Deprecated
    public MessageHistory newMessageHistory(String routeId, NamedNode namedNode, Date date) {
        return this.newMessageHistory(routeId, namedNode, date.getTime());
    }

    public MessageHistory newMessageHistory(String routeId, NamedNode namedNode, long timestamp) {
        return new MicrometerMessageHistory(this.getMeterRegistry(), this.camelContext.getRoute(routeId), namedNode, this.getNamingStrategy(), timestamp);
    }

    protected void doStart() throws Exception {
        if (this.meterRegistry == null) {
            this.meterRegistry = MicrometerUtils.getOrCreateMeterRegistry(this.camelContext.getRegistry(), "metricsRegistry");
        }
        try {
            MicrometerMessageHistoryService messageHistoryService = (MicrometerMessageHistoryService)this.camelContext.hasService(MicrometerMessageHistoryService.class);
            if (messageHistoryService == null) {
                messageHistoryService = new MicrometerMessageHistoryService();
                messageHistoryService.setMeterRegistry(this.getMeterRegistry());
                messageHistoryService.setPrettyPrint(this.isPrettyPrint());
                messageHistoryService.setDurationUnit(this.getDurationUnit());
                messageHistoryService.setMatchingTags((Iterable<Tag>)Tags.of((String)"serviceName", (String)MicrometerMessageHistoryService.class.getSimpleName()));
                this.camelContext.addService((Object)messageHistoryService);
            }
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
    }

    protected void doStop() {
    }
}

