/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.cache;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.component.cache.DefaultCacheManagerFactory;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.processor.cache.CacheValidate;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class CacheBasedXPathReplacer
extends CacheValidate
implements Processor,
Service {
    private static final Logger LOG = LoggerFactory.getLogger(CacheBasedXPathReplacer.class);
    private CacheManager cacheManager;
    private String cacheName;
    private Expression key;
    private String xpath;

    public CacheBasedXPathReplacer(String cacheName, String key, String xpath) {
        this(cacheName, ExpressionBuilder.constantExpression((Object)key), xpath);
    }

    public CacheBasedXPathReplacer(String cacheName, Expression key, String xpath) {
        if (cacheName.contains("cache://")) {
            this.setCacheName(cacheName.replace("cache://", ""));
        } else {
            this.setCacheName(cacheName);
        }
        this.key = key;
        this.xpath = xpath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        String cacheKey = (String)this.key.evaluate(exchange, String.class);
        if (this.isValid(this.cacheManager, this.cacheName, cacheKey)) {
            Document document;
            Cache cache = this.cacheManager.getCache(this.cacheName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Replacing XPath value {} in Message with value stored against key {} in CacheName {}", new Object[]{this.xpath, cacheKey, this.cacheName});
            }
            exchange.getIn().setHeader("CamelCacheKey", (Object)cacheKey);
            Object body = exchange.getIn().getBody();
            InputStream is = (InputStream)exchange.getContext().getTypeConverter().convertTo(InputStream.class, body);
            try {
                document = (Document)exchange.getContext().getTypeConverter().convertTo(Document.class, exchange, (Object)is);
            }
            finally {
                IOHelper.close((Closeable)is, (String)"is", (Logger)LOG);
            }
            InputStream cis = (InputStream)exchange.getContext().getTypeConverter().convertTo(InputStream.class, cache.get((Serializable)((Object)cacheKey)).getObjectValue());
            try {
                Document cacheValueDocument = (Document)exchange.getContext().getTypeConverter().convertTo(Document.class, exchange, (Object)cis);
                XmlConverter xmlConverter = new XmlConverter();
                String xslString = IOConverter.toString((File)new File("./src/main/resources/xpathreplacer.xsl"), (Exchange)exchange);
                xslString = xslString.replace("##match_token##", this.xpath);
                StreamSource xslSource = xmlConverter.toStreamSource((Reader)new StringReader(xslString));
                TransformerFactory transformerFactory = xmlConverter.createTransformerFactory();
                Transformer transformer = transformerFactory.newTransformer(xslSource);
                DOMSource source = xmlConverter.toDOMSource(document);
                DOMResult result = new DOMResult();
                transformer.setParameter("cacheValue", cacheValueDocument);
                transformer.transform(source, result);
                DOMSource dom = new DOMSource(result.getNode());
                exchange.getIn().setBody((Object)dom, byte[].class);
            }
            finally {
                IOHelper.close((Closeable)cis, (String)"cis", (Logger)LOG);
            }
        }
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public Expression getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = ExpressionBuilder.constantExpression((Object)key);
    }

    public void setKey(Expression key) {
        this.key = key;
    }

    public String getXpath() {
        return this.xpath;
    }

    public void setXpath(String xpath) {
        this.xpath = xpath;
    }

    public void start() throws Exception {
        if (this.cacheManager == null) {
            this.cacheManager = new DefaultCacheManagerFactory().getInstance();
        }
    }

    public void stop() throws Exception {
    }
}

