/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.flink;

import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.flink.DataSetCallback;
import org.apache.camel.component.flink.FlinkEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.flink.api.java.DataSet;

public class DataSetFlinkProducer
extends DefaultProducer {
    public DataSetFlinkProducer(FlinkEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        Object result;
        DataSet ds = this.resolveDataSet(exchange);
        DataSetCallback dataSetCallback = this.resolveDataSetCallback(exchange);
        Object body = exchange.getIn().getBody();
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(DataSet.class.getClassLoader());
            if (body instanceof List) {
                List list = (List)body;
                Object[] array = list.toArray(new Object[list.size()]);
                result = dataSetCallback.onDataSet(ds, array);
            } else {
                result = dataSetCallback.onDataSet(ds, body);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
        this.collectResults(exchange, result);
    }

    public FlinkEndpoint getEndpoint() {
        return (FlinkEndpoint)super.getEndpoint();
    }

    protected void collectResults(Exchange exchange, Object result) throws Exception {
        if (result instanceof DataSet) {
            DataSet dsResults = (DataSet)result;
            if (this.getEndpoint().isCollect()) {
                exchange.getIn().setBody((Object)dsResults.collect());
            } else {
                exchange.getIn().setBody(result);
                exchange.getIn().setHeader("CamelFlinkDataSet", result);
            }
        } else {
            exchange.getIn().setBody(result);
        }
    }

    protected DataSet resolveDataSet(Exchange exchange) {
        if (exchange.getIn().getHeader("CamelFlinkDataSet") != null) {
            return (DataSet)exchange.getIn().getHeader("CamelFlinkDataSet");
        }
        if (this.getEndpoint().getDataSet() != null) {
            return this.getEndpoint().getDataSet();
        }
        throw new IllegalStateException("No DataSet defined");
    }

    protected DataSetCallback resolveDataSetCallback(Exchange exchange) {
        if (exchange.getIn().getHeader("CamelFlinkDataSetCallback") != null) {
            return (DataSetCallback)exchange.getIn().getHeader("CamelFlinkDataSetCallback");
        }
        if (this.getEndpoint().getDataSetCallback() != null) {
            return this.getEndpoint().getDataSetCallback();
        }
        throw new IllegalStateException("Cannot resolve DataSet callback.");
    }
}

