/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir.internal;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.apache.camel.component.fhir.api.FhirRead;
import org.apache.camel.util.component.ApiMethod;
import org.apache.camel.util.component.ApiMethodArg;
import org.apache.camel.util.component.ApiMethodImpl;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;

public enum FhirReadApiMethod implements ApiMethod
{
    RESOURCEBYID(IBaseResource.class, "resourceById", ApiMethodArg.arg((String)"resource", Class.class), ApiMethodArg.arg((String)"id", IIdType.class), ApiMethodArg.arg((String)"ifVersionMatches", String.class), ApiMethodArg.arg((String)"returnNull", Boolean.class), ApiMethodArg.arg((String)"returnResource", IBaseResource.class), ApiMethodArg.arg((String)"throwError", Boolean.class), ApiMethodArg.arg((String)"extraParameters", Map.class)),
    RESOURCEBYID_1(IBaseResource.class, "resourceById", ApiMethodArg.arg((String)"resource", Class.class), ApiMethodArg.arg((String)"longId", Long.class), ApiMethodArg.arg((String)"ifVersionMatches", String.class), ApiMethodArg.arg((String)"returnNull", Boolean.class), ApiMethodArg.arg((String)"returnResource", IBaseResource.class), ApiMethodArg.arg((String)"throwError", Boolean.class), ApiMethodArg.arg((String)"extraParameters", Map.class)),
    RESOURCEBYID_2(IBaseResource.class, "resourceById", ApiMethodArg.arg((String)"resourceClass", String.class), ApiMethodArg.arg((String)"id", IIdType.class), ApiMethodArg.arg((String)"ifVersionMatches", String.class), ApiMethodArg.arg((String)"returnNull", Boolean.class), ApiMethodArg.arg((String)"returnResource", IBaseResource.class), ApiMethodArg.arg((String)"throwError", Boolean.class), ApiMethodArg.arg((String)"extraParameters", Map.class)),
    RESOURCEBYID_3(IBaseResource.class, "resourceById", ApiMethodArg.arg((String)"resourceClass", String.class), ApiMethodArg.arg((String)"longId", Long.class), ApiMethodArg.arg((String)"ifVersionMatches", String.class), ApiMethodArg.arg((String)"returnNull", Boolean.class), ApiMethodArg.arg((String)"returnResource", IBaseResource.class), ApiMethodArg.arg((String)"throwError", Boolean.class), ApiMethodArg.arg((String)"extraParameters", Map.class)),
    RESOURCEBYID_4(IBaseResource.class, "resourceById", ApiMethodArg.arg((String)"resource", Class.class), ApiMethodArg.arg((String)"stringId", String.class), ApiMethodArg.arg((String)"version", String.class), ApiMethodArg.arg((String)"ifVersionMatches", String.class), ApiMethodArg.arg((String)"returnNull", Boolean.class), ApiMethodArg.arg((String)"returnResource", IBaseResource.class), ApiMethodArg.arg((String)"throwError", Boolean.class), ApiMethodArg.arg((String)"extraParameters", Map.class)),
    RESOURCEBYID_5(IBaseResource.class, "resourceById", ApiMethodArg.arg((String)"resourceClass", String.class), ApiMethodArg.arg((String)"stringId", String.class), ApiMethodArg.arg((String)"ifVersionMatches", String.class), ApiMethodArg.arg((String)"version", String.class), ApiMethodArg.arg((String)"returnNull", Boolean.class), ApiMethodArg.arg((String)"returnResource", IBaseResource.class), ApiMethodArg.arg((String)"throwError", Boolean.class), ApiMethodArg.arg((String)"extraParameters", Map.class)),
    RESOURCEBYURL(IBaseResource.class, "resourceByUrl", ApiMethodArg.arg((String)"resource", Class.class), ApiMethodArg.arg((String)"iUrl", IIdType.class), ApiMethodArg.arg((String)"ifVersionMatches", String.class), ApiMethodArg.arg((String)"returnNull", Boolean.class), ApiMethodArg.arg((String)"returnResource", IBaseResource.class), ApiMethodArg.arg((String)"throwError", Boolean.class), ApiMethodArg.arg((String)"extraParameters", Map.class)),
    RESOURCEBYURL_1(IBaseResource.class, "resourceByUrl", ApiMethodArg.arg((String)"resource", Class.class), ApiMethodArg.arg((String)"url", String.class), ApiMethodArg.arg((String)"ifVersionMatches", String.class), ApiMethodArg.arg((String)"returnNull", Boolean.class), ApiMethodArg.arg((String)"returnResource", IBaseResource.class), ApiMethodArg.arg((String)"throwError", Boolean.class), ApiMethodArg.arg((String)"extraParameters", Map.class)),
    RESOURCEBYURL_2(IBaseResource.class, "resourceByUrl", ApiMethodArg.arg((String)"resourceClass", String.class), ApiMethodArg.arg((String)"iUrl", IIdType.class), ApiMethodArg.arg((String)"ifVersionMatches", String.class), ApiMethodArg.arg((String)"returnNull", Boolean.class), ApiMethodArg.arg((String)"returnResource", IBaseResource.class), ApiMethodArg.arg((String)"throwError", Boolean.class), ApiMethodArg.arg((String)"extraParameters", Map.class)),
    RESOURCEBYURL_3(IBaseResource.class, "resourceByUrl", ApiMethodArg.arg((String)"resourceClass", String.class), ApiMethodArg.arg((String)"url", String.class), ApiMethodArg.arg((String)"ifVersionMatches", String.class), ApiMethodArg.arg((String)"returnNull", Boolean.class), ApiMethodArg.arg((String)"returnResource", IBaseResource.class), ApiMethodArg.arg((String)"throwError", Boolean.class), ApiMethodArg.arg((String)"extraParameters", Map.class));

    private final ApiMethod apiMethod;

    private FhirReadApiMethod(Class<?> resultType, String name, ApiMethodArg ... args) {
        this.apiMethod = new ApiMethodImpl(FhirRead.class, resultType, name, args);
    }

    public String getName() {
        return this.apiMethod.getName();
    }

    public Class<?> getResultType() {
        return this.apiMethod.getResultType();
    }

    public List<String> getArgNames() {
        return this.apiMethod.getArgNames();
    }

    public List<Class<?>> getArgTypes() {
        return this.apiMethod.getArgTypes();
    }

    public Method getMethod() {
        return this.apiMethod.getMethod();
    }
}

