/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elasticsearch5;

import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.util.ArrayList;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.elasticsearch5.ElasticsearchConfiguration;
import org.apache.camel.component.elasticsearch5.ElasticsearchEndpoint;
import org.apache.camel.component.elasticsearch5.ElasticsearchOperation;
import org.apache.camel.impl.DefaultProducer;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchProducer.class);
    protected final ElasticsearchConfiguration configuration;
    private TransportClient client;

    public ElasticsearchProducer(ElasticsearchEndpoint endpoint, ElasticsearchConfiguration configuration) {
        super((Endpoint)endpoint);
        this.configuration = configuration;
        this.client = endpoint.getClient();
    }

    private ElasticsearchOperation resolveOperation(Exchange exchange) {
        Object request = exchange.getIn().getBody();
        if (request instanceof IndexRequest) {
            return ElasticsearchOperation.INDEX;
        }
        if (request instanceof GetRequest) {
            return ElasticsearchOperation.GET_BY_ID;
        }
        if (request instanceof MultiGetRequest) {
            return ElasticsearchOperation.MULTIGET;
        }
        if (request instanceof UpdateRequest) {
            return ElasticsearchOperation.UPDATE;
        }
        if (request instanceof BulkRequest) {
            if (this.configuration.getOperation() == ElasticsearchOperation.BULK_INDEX) {
                return ElasticsearchOperation.BULK_INDEX;
            }
            return ElasticsearchOperation.BULK;
        }
        if (request instanceof DeleteRequest) {
            return ElasticsearchOperation.DELETE;
        }
        if (request instanceof SearchRequest) {
            return ElasticsearchOperation.SEARCH;
        }
        if (request instanceof MultiSearchRequest) {
            return ElasticsearchOperation.MULTISEARCH;
        }
        if (request instanceof DeleteIndexRequest) {
            return ElasticsearchOperation.DELETE_INDEX;
        }
        ElasticsearchOperation operationConfig = (ElasticsearchOperation)((Object)exchange.getIn().getHeader("operation", ElasticsearchOperation.class));
        if (operationConfig == null) {
            operationConfig = this.configuration.getOperation();
        }
        if (operationConfig == null) {
            throw new IllegalArgumentException("operation value '" + (Object)((Object)operationConfig) + "' is not supported");
        }
        return operationConfig;
    }

    public void process(Exchange exchange) throws Exception {
        Message message = exchange.getIn();
        ElasticsearchOperation operation = this.resolveOperation(exchange);
        boolean configIndexName = false;
        String indexName = (String)message.getHeader("indexName", String.class);
        if (indexName == null) {
            message.setHeader("indexName", (Object)this.configuration.getIndexName());
            configIndexName = true;
        }
        boolean configIndexType = false;
        String indexType = (String)message.getHeader("indexType", String.class);
        if (indexType == null) {
            message.setHeader("indexType", (Object)this.configuration.getIndexType());
            configIndexType = true;
        }
        boolean configWaitForActiveShards = false;
        Integer waitForActiveShards = (Integer)message.getHeader("waitForActiveShards", Integer.class);
        if (waitForActiveShards == null) {
            message.setHeader("waitForActiveShards", (Object)this.configuration.getWaitForActiveShards());
            configWaitForActiveShards = true;
        }
        if (operation == ElasticsearchOperation.INDEX) {
            IndexRequest indexRequest = (IndexRequest)message.getBody(IndexRequest.class);
            message.setBody((Object)((IndexResponse)this.client.index(indexRequest).actionGet()).getId());
        } else if (operation == ElasticsearchOperation.UPDATE) {
            UpdateRequest updateRequest = (UpdateRequest)message.getBody(UpdateRequest.class);
            message.setBody((Object)((UpdateResponse)this.client.update(updateRequest).actionGet()).getId());
        } else if (operation == ElasticsearchOperation.GET_BY_ID) {
            GetRequest getRequest = (GetRequest)message.getBody(GetRequest.class);
            message.setBody((Object)this.client.get(getRequest));
        } else if (operation == ElasticsearchOperation.MULTIGET) {
            MultiGetRequest multiGetRequest = (MultiGetRequest)message.getBody(MultiGetRequest.class);
            message.setBody((Object)this.client.multiGet(multiGetRequest));
        } else if (operation == ElasticsearchOperation.BULK) {
            BulkRequest bulkRequest = (BulkRequest)message.getBody(BulkRequest.class);
            message.setBody(this.client.bulk(bulkRequest).actionGet());
        } else if (operation == ElasticsearchOperation.BULK_INDEX) {
            BulkRequest bulkRequest = (BulkRequest)message.getBody(BulkRequest.class);
            ArrayList<String> indexedIds = new ArrayList<String>();
            for (BulkItemResponse response : ((BulkResponse)this.client.bulk(bulkRequest).actionGet()).getItems()) {
                indexedIds.add(response.getId());
            }
            message.setBody(indexedIds);
        } else if (operation == ElasticsearchOperation.DELETE) {
            DeleteRequest deleteRequest = (DeleteRequest)message.getBody(DeleteRequest.class);
            message.setBody(this.client.delete(deleteRequest).actionGet());
        } else if (operation == ElasticsearchOperation.EXISTS) {
            SearchRequest searchRequest = new SearchRequest(new String[]{(String)exchange.getIn().getHeader("indexName", String.class)});
            try {
                this.client.prepareSearch(searchRequest.indices()).setSize(0).setTerminateAfter(1).get();
                message.setBody((Object)true);
            }
            catch (IndexNotFoundException e) {
                message.setBody((Object)false);
            }
        } else if (operation == ElasticsearchOperation.SEARCH) {
            SearchRequest searchRequest = (SearchRequest)message.getBody(SearchRequest.class);
            message.setBody(this.client.search(searchRequest).actionGet());
        } else if (operation == ElasticsearchOperation.MULTISEARCH) {
            MultiSearchRequest multiSearchRequest = (MultiSearchRequest)message.getBody(MultiSearchRequest.class);
            message.setBody((Object)this.client.multiSearch(multiSearchRequest));
        } else if (operation == ElasticsearchOperation.DELETE_INDEX) {
            DeleteIndexRequest deleteIndexRequest = (DeleteIndexRequest)message.getBody(DeleteIndexRequest.class);
            message.setBody(this.client.admin().indices().delete(deleteIndexRequest).actionGet());
        } else {
            throw new IllegalArgumentException("operation value '" + (Object)((Object)operation) + "' is not supported");
        }
        if (configIndexName) {
            message.removeHeader("indexName");
        }
        if (configIndexType) {
            message.removeHeader("indexType");
        }
        if (configWaitForActiveShards) {
            message.removeHeader("waitForActiveShards");
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.client == null) {
            LOG.info("Connecting to the ElasticSearch cluster: {}", (Object)this.configuration.getClusterName());
            if (this.configuration.getIp() != null) {
                this.client = this.createClient().addTransportAddress((TransportAddress)new InetSocketTransportAddress(InetAddress.getByName(this.configuration.getIp()), this.configuration.getPort()));
            } else if (this.configuration.getTransportAddressesList() != null && !this.configuration.getTransportAddressesList().isEmpty()) {
                ArrayList<InetSocketTransportAddress> addresses = new ArrayList<InetSocketTransportAddress>(this.configuration.getTransportAddressesList().size());
                addresses.addAll(this.configuration.getTransportAddressesList());
                this.client = this.createClient().addTransportAddresses(addresses.toArray(new TransportAddress[addresses.size()]));
            } else {
                LOG.info("Incorrect ip address and port parameters settings for ElasticSearch cluster");
            }
        }
    }

    private TransportClient createClient() throws Exception {
        Settings.Builder settings = this.getSettings();
        CamelContext camelContext = this.getEndpoint().getCamelContext();
        Class clazz = camelContext.getClassResolver().resolveClass("org.elasticsearch.xpack.client.PreBuiltXPackTransportClient");
        if (clazz != null) {
            Constructor ctor = clazz.getConstructor(Settings.class, Class[].class);
            settings.put("xpack.security.user", this.configuration.getUser() + ":" + this.configuration.getPassword()).put("xpack.security.transport.ssl.enabled", this.configuration.getEnableSSL());
            LOG.info("XPack Client was found on the classpath");
            return (TransportClient)ctor.newInstance(settings.build(), new Class[0]);
        }
        LOG.debug("XPack Client was not found on the classpath, using the standard client.");
        return new PreBuiltTransportClient(settings.build(), new Class[0]);
    }

    private Settings.Builder getSettings() {
        Settings.Builder settings = Settings.builder().put("cluster.name", this.configuration.getClusterName()).put("client.transport.sniff", this.configuration.getClientTransportSniff()).put("transport.ping_schedule", this.configuration.getPingSchedule()).put("client.transport.ping_timeout", this.configuration.getPingTimeout()).put("client.transport.sniff", this.configuration.getClientTransportSniff()).put("request.headers.X-Found-Cluster", this.configuration.getClusterName());
        return settings;
    }

    protected void doStop() throws Exception {
        if (this.client != null) {
            LOG.info("Disconnecting from ElasticSearch cluster: {}", (Object)this.configuration.getClusterName());
            this.client.close();
            this.client = null;
        }
        super.doStop();
    }

    public TransportClient getClient() {
        return this.client;
    }
}

