/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.linkedin.api;

import java.io.IOException;
import java.util.Map;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.camel.component.linkedin.api.LinkedInException;
import org.apache.camel.component.linkedin.api.model.Error;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Provider
@Priority(value=5000)
public class LinkedInExceptionResponseFilter
implements ClientResponseFilter {
    private static final Logger LOG = LoggerFactory.getLogger(LinkedInExceptionResponseFilter.class);
    private final JAXBContext jaxbContext;

    public LinkedInExceptionResponseFilter() {
        try {
            this.jaxbContext = JAXBContext.newInstance((String)Error.class.getPackage().getName());
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Error initializing JAXB: " + e.getMessage(), e);
        }
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        if (responseContext.getStatus() != Response.Status.OK.getStatusCode() && responseContext.hasEntity()) {
            try {
                Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
                SAXParserFactory spf = SAXParserFactory.newInstance();
                try {
                    spf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
                    spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
                    spf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                    spf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                }
                catch (ParserConfigurationException | SAXException ex) {
                    LOG.debug("Error setting feature on parser: " + ex.getMessage());
                }
                SAXSource xmlSource = new SAXSource(spf.newSAXParser().getXMLReader(), new InputSource(responseContext.getEntityStream()));
                Error error = (Error)unmarshaller.unmarshal((Source)xmlSource);
                Response.ResponseBuilder builder = Response.status((Response.StatusType)responseContext.getStatusInfo());
                builder.entity((Object)error);
                for (Map.Entry header : responseContext.getHeaders().entrySet()) {
                    builder.header((String)header.getKey(), header.getValue());
                }
                throw new LinkedInException(error, builder.build());
            }
            catch (JAXBException | ParserConfigurationException | SAXException e) {
                LOG.warn("Unable to parse LinkedIn error: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }
}

