/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.web3j;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.web3j.Web3jConfiguration;
import org.apache.camel.component.web3j.Web3jEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.EthBlock;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.Transaction;
import rx.Subscription;

public class Web3jConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(Web3jConsumer.class);
    private final Web3j web3j;
    private final Web3jConfiguration configuration;
    private Subscription subscription;
    private Web3jEndpoint endpoint;

    public Web3jConsumer(Web3jEndpoint endpoint, Processor processor, Web3jConfiguration configuration) {
        super((Endpoint)endpoint, processor);
        this.web3j = endpoint.getWeb3j();
        this.endpoint = endpoint;
        this.configuration = configuration;
    }

    public Web3jEndpoint getEndpoint() {
        return (Web3jEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        LOG.info("Subscribing to: {}", (Object)this.endpoint.getNodeAddress());
        switch (this.configuration.getOperation()) {
            case "ETH_LOG_OBSERVABLE": {
                EthFilter ethFilter = Web3jEndpoint.buildEthFilter(this.configuration.getFromBlock(), this.configuration.getToBlock(), this.configuration.getAddresses(), this.configuration.getTopics());
                this.subscription = this.web3j.ethLogObservable(ethFilter).subscribe(x -> this.ethLogObservable((Log)x), t -> this.processError((Throwable)t, "ETH_LOG_OBSERVABLE"), () -> this.processDone("ETH_LOG_OBSERVABLE"));
                break;
            }
            case "ETH_BLOCK_HASH_OBSERVABLE": {
                this.subscription = this.web3j.ethBlockHashObservable().subscribe(x -> this.ethBlockHashObservable((String)x), t -> this.processError((Throwable)t, "ETH_BLOCK_HASH_OBSERVABLE"), () -> this.processDone("ETH_BLOCK_HASH_OBSERVABLE"));
                break;
            }
            case "ETH_PENDING_TRANSACTION_HASH_OBSERVABLE": {
                this.subscription = this.web3j.ethPendingTransactionHashObservable().subscribe(x -> this.ethPendingTransactionHashObservable((String)x), t -> this.processError((Throwable)t, "ETH_PENDING_TRANSACTION_HASH_OBSERVABLE"), () -> this.processDone("ETH_PENDING_TRANSACTION_HASH_OBSERVABLE"));
                break;
            }
            case "TRANSACTION_OBSERVABLE": {
                this.subscription = this.web3j.transactionObservable().subscribe(x -> this.processTransaction((Transaction)x), t -> this.processError((Throwable)t, "TRANSACTION_OBSERVABLE"), () -> this.processDone("TRANSACTION_OBSERVABLE"));
                break;
            }
            case "PENDING_TRANSACTION_OBSERVABLE": {
                this.subscription = this.web3j.pendingTransactionObservable().subscribe(x -> this.processTransaction((Transaction)x), t -> this.processError((Throwable)t, "PENDING_TRANSACTION_OBSERVABLE"), () -> this.processDone("PENDING_TRANSACTION_OBSERVABLE"));
                break;
            }
            case "BLOCK_OBSERVABLE": {
                this.subscription = this.web3j.blockObservable(this.configuration.isFullTransactionObjects()).subscribe(x -> this.blockObservable((EthBlock)x), t -> this.processError((Throwable)t, "BLOCK_OBSERVABLE"), () -> this.processDone("BLOCK_OBSERVABLE"));
                break;
            }
            case "REPLAY_BLOCKS_OBSERVABLE": {
                this.subscription = this.web3j.replayBlocksObservable(this.configuration.getFromBlock(), this.configuration.getToBlock(), this.configuration.isFullTransactionObjects()).subscribe(x -> this.blockObservable((EthBlock)x), t -> this.processError((Throwable)t, "REPLAY_BLOCKS_OBSERVABLE"), () -> this.processDone("REPLAY_BLOCKS_OBSERVABLE"));
                break;
            }
            case "REPLAY_TRANSACTIONS_OBSERVABLE": {
                this.subscription = this.web3j.replayTransactionsObservable(this.configuration.getFromBlock(), this.configuration.getToBlock()).subscribe(x -> this.processTransaction((Transaction)x), t -> this.processError((Throwable)t, "REPLAY_TRANSACTIONS_OBSERVABLE"), () -> this.processDone("REPLAY_TRANSACTIONS_OBSERVABLE"));
                break;
            }
            case "CATCH_UP_TO_LATEST_BLOCK_OBSERVABLE": {
                this.subscription = this.web3j.catchUpToLatestBlockObservable(this.configuration.getFromBlock(), this.configuration.isFullTransactionObjects()).subscribe(x -> this.blockObservable((EthBlock)x), t -> this.processError((Throwable)t, "CATCH_UP_TO_LATEST_BLOCK_OBSERVABLE"), () -> this.processDone("CATCH_UP_TO_LATEST_BLOCK_OBSERVABLE"));
                break;
            }
            case "CATCH_UP_TO_LATEST_TRANSACTION_OBSERVABLE": {
                this.subscription = this.web3j.catchUpToLatestTransactionObservable(this.configuration.getFromBlock()).subscribe(x -> this.processTransaction((Transaction)x), t -> this.processError((Throwable)t, "CATCH_UP_TO_LATEST_TRANSACTION_OBSERVABLE"), () -> this.processDone("CATCH_UP_TO_LATEST_TRANSACTION_OBSERVABLE"));
                break;
            }
            case "CATCH_UP_TO_LATEST_AND_SUBSCRIBE_TO_NEW_BLOCKS_OBSERVABLE": {
                this.subscription = this.web3j.catchUpToLatestAndSubscribeToNewBlocksObservable(this.configuration.getFromBlock(), this.configuration.isFullTransactionObjects()).subscribe(x -> this.blockObservable((EthBlock)x), t -> this.processError((Throwable)t, "CATCH_UP_TO_LATEST_AND_SUBSCRIBE_TO_NEW_BLOCKS_OBSERVABLE"), () -> this.processDone("CATCH_UP_TO_LATEST_AND_SUBSCRIBE_TO_NEW_BLOCKS_OBSERVABLE"));
                break;
            }
            case "CATCH_UP_TO_LATEST_AND_SUBSCRIBE_TO_NEW_TRANSACTIONS_OBSERVABLE": {
                this.subscription = this.web3j.catchUpToLatestAndSubscribeToNewTransactionsObservable(this.configuration.getFromBlock()).subscribe(x -> this.processTransaction((Transaction)x), t -> this.processError((Throwable)t, "CATCH_UP_TO_LATEST_AND_SUBSCRIBE_TO_NEW_TRANSACTIONS_OBSERVABLE"), () -> this.processDone("CATCH_UP_TO_LATEST_AND_SUBSCRIBE_TO_NEW_TRANSACTIONS_OBSERVABLE"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + this.configuration.getOperation());
            }
        }
        LOG.info("Subscribed: {}", (Object)this.configuration);
    }

    private EthFilter buildEthFilter() {
        EthFilter ethFilter = new EthFilter(this.configuration.getFromBlock(), this.configuration.getToBlock(), this.configuration.getAddresses());
        if (this.configuration.getTopics() != null) {
            for (String topic : this.configuration.getTopics()) {
                if (topic != null && topic.length() > 0) {
                    ethFilter.addSingleTopic(topic);
                    continue;
                }
                ethFilter.addNullTopic();
            }
        }
        return ethFilter;
    }

    private void ethBlockHashObservable(String x) {
        LOG.debug("processEthBlock {}", (Object)x);
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.getIn().setBody((Object)x);
        this.processEvent(exchange);
    }

    private void ethPendingTransactionHashObservable(String x) {
        LOG.debug("processEthBlock {}", (Object)x);
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.getIn().setBody((Object)x);
        this.processEvent(exchange);
    }

    private void blockObservable(EthBlock x) {
        EthBlock.Block block = x.getBlock();
        LOG.debug("processEthBlock {}", (Object)block);
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.getIn().setBody((Object)block);
        this.processEvent(exchange);
    }

    private void processTransaction(Transaction x) {
        LOG.debug("processTransaction {}", (Object)x);
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.getIn().setBody((Object)x);
        this.processEvent(exchange);
    }

    private void ethLogObservable(Log x) {
        LOG.debug("processLogObservable {}", (Object)x);
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.getIn().setBody((Object)x);
        this.processEvent(exchange);
    }

    public void processEvent(Exchange exchange) {
        LOG.debug("processEvent {}", (Object)exchange);
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            LOG.error("Error processing event ", (Throwable)e);
        }
    }

    private void processDone(String operation) {
        LOG.debug("processDone for operation: {}", (Object)operation);
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.getIn().setHeader("status", (Object)"done");
        exchange.getIn().setHeader("operation", (Object)operation);
        this.processEvent(exchange);
    }

    private void processError(Throwable throwable, String operation) {
        LOG.debug("processError for operation: " + operation + " " + throwable);
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.setException(throwable);
        this.processEvent(exchange);
    }

    protected void doStop() throws Exception {
        if (this.subscription != null) {
            this.subscription.unsubscribe();
        }
        super.doStop();
    }
}

