/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.cloud.consul;

import com.ecwid.consul.v1.agent.model.NewService;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.spring.boot.cloud.CamelCloudConfigurationProperties;
import org.springframework.cloud.consul.serviceregistry.ConsulRegistration;
import org.springframework.core.convert.converter.Converter;

public final class ServiceDefinitionToConsulRegistration
implements Converter<ServiceDefinition, ConsulRegistration> {
    private final CamelCloudConfigurationProperties properties;

    public ServiceDefinitionToConsulRegistration(CamelCloudConfigurationProperties properties) {
        this.properties = properties;
    }

    public ConsulRegistration convert(final ServiceDefinition source) {
        final NewService service = new NewService();
        service.setName(source.getName());
        service.setId(source.getId());
        service.setAddress(this.properties.getServiceRegistry().getServiceHost());
        service.setPort(Integer.valueOf(source.getPort()));
        service.setTags(source.getMetadata().entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.toList()));
        return new ConsulRegistration(service, null){

            public boolean isSecure() {
                return service.getPort() == 443 || Objects.equals("https", source.getMetadata().get("service.protocol"));
            }
        };
    }
}

