/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atomix.client;

import io.atomix.AtomixClient;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.atomix.AtomixConfiguration;
import org.apache.camel.component.atomix.client.AbstractAtomixClientComponent;
import org.apache.camel.component.atomix.client.AtomixClientConfiguration;
import org.apache.camel.component.atomix.client.AtomixClientHelper;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;

public abstract class AbstractAtomixClientEndpoint<T extends AbstractAtomixClientComponent, C extends AtomixClientConfiguration>
extends DefaultEndpoint {
    @UriPath(description="The distributed resource name")
    @Metadata(required="true")
    private final String resourceName;
    private AtomixClient atomix;

    protected AbstractAtomixClientEndpoint(String uri, T component, String resourceName) {
        super(uri, component);
        this.resourceName = resourceName;
    }

    public boolean isSingleton() {
        return true;
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("Producer not supported");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer not supported");
    }

    protected void doStart() throws Exception {
        if (this.atomix == null) {
            C configuration = this.getConfiguration();
            CamelContext context = this.getCamelContext();
            ObjectHelper.notNull(configuration, (String)"Configuration");
            ObjectHelper.notNull((Object)context, (String)"CamelContext");
            this.atomix = AtomixClientHelper.createClient(context, configuration);
            this.atomix.connect(((AtomixConfiguration)configuration).getNodes()).join();
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.atomix != null) {
            this.atomix.close();
        }
    }

    public T getAtomixComponent() {
        return (T)((Object)((AbstractAtomixClientComponent)super.getComponent()));
    }

    public AtomixClient getAtomix() {
        return this.atomix;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public abstract C getConfiguration();

    public abstract void setConfiguration(C var1);
}

