/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.iota;

import java.net.URL;
import jota.IotaAPI;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.iota.IOTAComponent;
import org.apache.camel.component.iota.IOTAProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;

@UriEndpoint(firstVersion="2.23.0", scheme="iota", title="IOTA", syntax="iota:name", label="dlt")
public class IOTAEndpoint
extends DefaultEndpoint {
    private IotaAPI apiClient;
    @UriPath
    @Metadata(required="true")
    private String name;
    @UriParam
    private String url;
    @UriParam
    private String operation;
    @UriParam
    private String tag;
    @UriParam(defaultValue="1")
    private Integer securityLevel = 1;
    @UriParam(defaultValue="14")
    private Integer minWeightMagnitude = 14;
    @UriParam(defaultValue="9")
    private Integer depth = 9;

    public IOTAEndpoint() {
    }

    public IOTAEndpoint(String uri, IOTAComponent component) {
        super(uri, (Component)component);
    }

    public Producer createProducer() throws Exception {
        return new IOTAProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("IOTAConsumer is not supported!");
    }

    public boolean isSingleton() {
        return true;
    }

    protected void doStart() throws Exception {
        URL u = new URL(this.url);
        this.apiClient = ((IotaAPI.Builder)((IotaAPI.Builder)((IotaAPI.Builder)new IotaAPI.Builder().protocol(u.getProtocol())).host(u.getHost())).port(String.valueOf(u.getPort()))).build();
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.apiClient = null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public Integer getSecurityLevel() {
        return this.securityLevel;
    }

    public void setSecurityLevel(Integer securityLevel) {
        this.securityLevel = securityLevel;
    }

    public Integer getMinWeightMagnitude() {
        return this.minWeightMagnitude;
    }

    public void setMinWeightMagnitude(Integer minWeightMagnitude) {
        this.minWeightMagnitude = minWeightMagnitude;
    }

    public Integer getDepth() {
        return this.depth;
    }

    public void setDepth(Integer depth) {
        this.depth = depth;
    }

    public IotaAPI getApiClient() {
        return this.apiClient;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }
}

